/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import discord4j.discordjson.json.ImmutableAuthorizationCodeGrantRequest;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AuthorizationCodeGrantRequest {
    public static ImmutableAuthorizationCodeGrantRequest.Builder builder() {
        return ImmutableAuthorizationCodeGrantRequest.builder();
    }

    public abstract long clientId();

    public abstract String clientSecret();

    public abstract String code();

    public abstract String redirectUri();

    public String toString() {
        String redirectUri;
        try {
            redirectUri = URLEncoder.encode(this.redirectUri(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
        return "client_id=" + this.clientId() + "&client_secret=" + this.clientSecret() + "&grant_type=authorization_code&code=" + this.code() + "&redirect_uri=" + redirectUri;
    }
}

