/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationCommandPermissionsData;
import discord4j.discordjson.json.GuildApplicationCommandPermissionsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="GuildApplicationCommandPermissionsData", generator="Immutables")
public final class ImmutableGuildApplicationCommandPermissionsData
implements GuildApplicationCommandPermissionsData {
    private final String id;
    private final String applicationId;
    private final String guildId;
    private final List<ApplicationCommandPermissionsData> permissions;

    private ImmutableGuildApplicationCommandPermissionsData(String id, String applicationId, String guildId, Iterable<? extends ApplicationCommandPermissionsData> permissions) {
        this.id = Objects.requireNonNull(id, "id");
        this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
        this.guildId = Objects.requireNonNull(guildId, "guildId");
        this.permissions = ImmutableGuildApplicationCommandPermissionsData.createUnmodifiableList(false, ImmutableGuildApplicationCommandPermissionsData.createSafeList(permissions, true, false));
    }

    private ImmutableGuildApplicationCommandPermissionsData(ImmutableGuildApplicationCommandPermissionsData original, String id, String applicationId, String guildId, List<ApplicationCommandPermissionsData> permissions) {
        this.id = id;
        this.applicationId = applicationId;
        this.guildId = guildId;
        this.permissions = permissions;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="application_id")
    public String applicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="guild_id")
    public String guildId() {
        return this.guildId;
    }

    @Override
    @JsonProperty(value="permissions")
    public List<ApplicationCommandPermissionsData> permissions() {
        return this.permissions;
    }

    public final ImmutableGuildApplicationCommandPermissionsData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildApplicationCommandPermissionsData(this, newValue, this.applicationId, this.guildId, this.permissions);
    }

    public final ImmutableGuildApplicationCommandPermissionsData withApplicationId(String value) {
        String newValue = Objects.requireNonNull(value, "applicationId");
        if (this.applicationId.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildApplicationCommandPermissionsData(this, this.id, newValue, this.guildId, this.permissions);
    }

    public final ImmutableGuildApplicationCommandPermissionsData withGuildId(String value) {
        String newValue = Objects.requireNonNull(value, "guildId");
        if (this.guildId.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildApplicationCommandPermissionsData(this, this.id, this.applicationId, newValue, this.permissions);
    }

    public final ImmutableGuildApplicationCommandPermissionsData withPermissions(ApplicationCommandPermissionsData ... elements) {
        List<ApplicationCommandPermissionsData> newValue = ImmutableGuildApplicationCommandPermissionsData.createUnmodifiableList(false, ImmutableGuildApplicationCommandPermissionsData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildApplicationCommandPermissionsData(this, this.id, this.applicationId, this.guildId, newValue);
    }

    public final ImmutableGuildApplicationCommandPermissionsData withPermissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
        if (this.permissions == elements) {
            return this;
        }
        List<ApplicationCommandPermissionsData> newValue = ImmutableGuildApplicationCommandPermissionsData.createUnmodifiableList(false, ImmutableGuildApplicationCommandPermissionsData.createSafeList(elements, true, false));
        return new ImmutableGuildApplicationCommandPermissionsData(this, this.id, this.applicationId, this.guildId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildApplicationCommandPermissionsData && this.equalTo(0, (ImmutableGuildApplicationCommandPermissionsData)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildApplicationCommandPermissionsData another) {
        return this.id.equals(another.id) && this.applicationId.equals(another.applicationId) && this.guildId.equals(another.guildId) && this.permissions.equals(another.permissions);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.id.hashCode();
        h2 += (h2 << 5) + this.applicationId.hashCode();
        h2 += (h2 << 5) + this.guildId.hashCode();
        h2 += (h2 << 5) + this.permissions.hashCode();
        return h2;
    }

    public String toString() {
        return "GuildApplicationCommandPermissionsData{id=" + this.id + ", applicationId=" + this.applicationId + ", guildId=" + this.guildId + ", permissions=" + this.permissions + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildApplicationCommandPermissionsData fromJson(Json json) {
        Builder builder = ImmutableGuildApplicationCommandPermissionsData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.permissions != null) {
            builder.addAllPermissions(json.permissions);
        }
        return builder.build();
    }

    public static ImmutableGuildApplicationCommandPermissionsData of(String id, String applicationId, String guildId, List<ApplicationCommandPermissionsData> permissions) {
        return ImmutableGuildApplicationCommandPermissionsData.of(id, applicationId, guildId, permissions);
    }

    public static ImmutableGuildApplicationCommandPermissionsData of(String id, String applicationId, String guildId, Iterable<? extends ApplicationCommandPermissionsData> permissions) {
        return new ImmutableGuildApplicationCommandPermissionsData(id, applicationId, guildId, permissions);
    }

    public static ImmutableGuildApplicationCommandPermissionsData copyOf(GuildApplicationCommandPermissionsData instance) {
        if (instance instanceof ImmutableGuildApplicationCommandPermissionsData) {
            return (ImmutableGuildApplicationCommandPermissionsData)instance;
        }
        return ImmutableGuildApplicationCommandPermissionsData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildApplicationCommandPermissionsData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_APPLICATION_ID = 2L;
        private static final long INIT_BIT_GUILD_ID = 4L;
        private long initBits = 7L;
        private String id;
        private String applicationId;
        private String guildId;
        private List<ApplicationCommandPermissionsData> permissions = new ArrayList<ApplicationCommandPermissionsData>();

        private Builder() {
        }

        public final Builder from(GuildApplicationCommandPermissionsData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.applicationId(instance.applicationId());
            this.guildId(instance.guildId());
            this.addAllPermissions(instance.permissions());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="application_id")
        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="guild_id")
        public final Builder guildId(String guildId) {
            this.guildId = Objects.requireNonNull(guildId, "guildId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addPermission(ApplicationCommandPermissionsData element) {
            this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            return this;
        }

        public final Builder addPermissions(ApplicationCommandPermissionsData ... elements) {
            for (ApplicationCommandPermissionsData element : elements) {
                this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            }
            return this;
        }

        @JsonProperty(value="permissions")
        public final Builder permissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
            this.permissions.clear();
            return this.addAllPermissions(elements);
        }

        public final Builder addAllPermissions(Iterable<? extends ApplicationCommandPermissionsData> elements) {
            for (ApplicationCommandPermissionsData applicationCommandPermissionsData : elements) {
                this.permissions.add(Objects.requireNonNull(applicationCommandPermissionsData, "permissions element"));
            }
            return this;
        }

        public ImmutableGuildApplicationCommandPermissionsData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildApplicationCommandPermissionsData(null, this.id, this.applicationId, this.guildId, ImmutableGuildApplicationCommandPermissionsData.createUnmodifiableList(true, this.permissions));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("guildId");
            }
            return "Cannot build GuildApplicationCommandPermissionsData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GuildApplicationCommandPermissionsData", generator="Immutables")
    static final class Json
    implements GuildApplicationCommandPermissionsData {
        String id;
        String applicationId;
        String guildId;
        List<ApplicationCommandPermissionsData> permissions = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="application_id")
        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(String guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(List<ApplicationCommandPermissionsData> permissions) {
            this.permissions = permissions;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String applicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ApplicationCommandPermissionsData> permissions() {
            throw new UnsupportedOperationException();
        }
    }
}

