/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.OnboardingPromptOptionData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="OnboardingPromptOptionData", generator="Immutables")
public final class ImmutableOnboardingPromptOptionData
implements OnboardingPromptOptionData {
    private final long id_value;
    private final long[] channelsIds_value;
    private final long[] rolesIds_value;
    private final EmojiData emoji;
    private final String title;
    private final String description;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOnboardingPromptOptionData(Id id, List<Id> channelsIds, List<Id> rolesIds, EmojiData emoji, String title, Optional<String> description) {
        Id id$impl = id;
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.emoji = Objects.requireNonNull(emoji, "emoji");
        this.title = Objects.requireNonNull(title, "title");
        this.description = description.orElse(null);
        this.id_value = id$impl.asLong();
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableOnboardingPromptOptionData(ImmutableOnboardingPromptOptionData original, Id id, List<Id> channelsIds, List<Id> rolesIds, EmojiData emoji, String title, String description) {
        Id id$impl = id;
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.emoji = emoji;
        this.title = title;
        this.description = description;
        this.id_value = id$impl.asLong();
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of(this.id_value);
    }

    @Override
    @JsonProperty(value="channel_ids")
    public List<Id> channelsIds() {
        return LongStream.of(this.channelsIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="role_ids")
    public List<Id> rolesIds() {
        return LongStream.of(this.rolesIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="emoji")
    public EmojiData emoji() {
        return this.emoji;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public ImmutableOnboardingPromptOptionData withId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableOnboardingPromptOptionData(this, newValue, this.channelsIds(), this.rolesIds(), this.emoji, this.title, this.description);
    }

    public ImmutableOnboardingPromptOptionData withId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableOnboardingPromptOptionData(this, newValue, this.channelsIds(), this.rolesIds(), this.emoji, this.title, this.description);
    }

    public ImmutableOnboardingPromptOptionData withChannelsIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingPromptOptionData(this, this.id(), newValue, this.rolesIds(), this.emoji, this.title, this.description);
    }

    public ImmutableOnboardingPromptOptionData withRolesIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingPromptOptionData(this, this.id(), this.channelsIds(), newValue, this.emoji, this.title, this.description);
    }

    public final ImmutableOnboardingPromptOptionData withEmoji(EmojiData value) {
        if (this.emoji == value) {
            return this;
        }
        EmojiData newValue = Objects.requireNonNull(value, "emoji");
        return new ImmutableOnboardingPromptOptionData(this, this.id(), this.channelsIds(), this.rolesIds(), newValue, this.title, this.description);
    }

    public final ImmutableOnboardingPromptOptionData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableOnboardingPromptOptionData(this, this.id(), this.channelsIds(), this.rolesIds(), this.emoji, newValue, this.description);
    }

    public final ImmutableOnboardingPromptOptionData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableOnboardingPromptOptionData(this, this.id(), this.channelsIds(), this.rolesIds(), this.emoji, this.title, newValue);
    }

    public final ImmutableOnboardingPromptOptionData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableOnboardingPromptOptionData(this, this.id(), this.channelsIds(), this.rolesIds(), this.emoji, this.title, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingPromptOptionData && this.equalTo(0, (ImmutableOnboardingPromptOptionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingPromptOptionData another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.channelsIds_value, another.channelsIds_value) && Objects.equals(this.rolesIds_value, another.rolesIds_value) && this.emoji.equals(another.emoji) && this.title.equals(another.title) && Objects.equals(this.description, another.description);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id_value);
        h2 += (h2 << 5) + Objects.hashCode(this.channelsIds_value);
        h2 += (h2 << 5) + Objects.hashCode(this.rolesIds_value);
        h2 += (h2 << 5) + this.emoji.hashCode();
        h2 += (h2 << 5) + this.title.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OnboardingPromptOptionData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("channelsIds=").append(Objects.toString(this.channelsIds_value));
        builder.append(", ");
        builder.append("rolesIds=").append(Objects.toString(this.rolesIds_value));
        builder.append(", ");
        builder.append("emoji=").append(this.emoji);
        builder.append(", ");
        builder.append("title=").append(this.title);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingPromptOptionData fromJson(Json json) {
        Builder builder = ImmutableOnboardingPromptOptionData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.channelsIds != null) {
            builder.channelsIds(json.channelsIds);
        }
        if (json.rolesIds != null) {
            builder.rolesIds(json.rolesIds);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableOnboardingPromptOptionData of(Id id, List<Id> channelsIds, List<Id> rolesIds, EmojiData emoji, String title, Optional<String> description) {
        return new ImmutableOnboardingPromptOptionData(id, channelsIds, rolesIds, emoji, title, description);
    }

    public static ImmutableOnboardingPromptOptionData copyOf(OnboardingPromptOptionData instance) {
        if (instance instanceof ImmutableOnboardingPromptOptionData) {
            return (ImmutableOnboardingPromptOptionData)instance;
        }
        return ImmutableOnboardingPromptOptionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OnboardingPromptOptionData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EMOJI = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private long initBits = 3L;
        private Id id_id = null;
        private List<Long> channelsIds_list = null;
        private List<Long> rolesIds_list = null;
        private EmojiData emoji;
        private String title;
        private String description;

        private Builder() {
        }

        public final Builder from(OnboardingPromptOptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.channelsIds(instance.channelsIds());
            this.rolesIds(instance.rolesIds());
            this.emoji(instance.emoji());
            this.title(instance.title());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of(value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public Builder addChannelsId(long element) {
            this.channelsIds_getOrCreate().add(element);
            return this;
        }

        public Builder addChannelsId(String element) {
            this.channelsIds_getOrCreate().add(Id.of(element).asLong());
            return this;
        }

        public Builder addChannelsId(Id element) {
            this.channelsIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllChannelsIds(List<Long> elements) {
            this.channelsIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="channel_ids")
        public Builder channelsIds(List<Id> elements) {
            this.channelsIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder channelsIds(Iterable<Id> elements) {
            this.channelsIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addRolesId(long element) {
            this.rolesIds_getOrCreate().add(element);
            return this;
        }

        public Builder addRolesId(String element) {
            this.rolesIds_getOrCreate().add(Id.of(element).asLong());
            return this;
        }

        public Builder addRolesId(Id element) {
            this.rolesIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllRolesIds(List<Long> elements) {
            this.rolesIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="role_ids")
        public Builder rolesIds(List<Id> elements) {
            this.rolesIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder rolesIds(Iterable<Id> elements) {
            this.rolesIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="emoji")
        public final Builder emoji(EmojiData emoji) {
            this.emoji = Objects.requireNonNull(emoji, "emoji");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public ImmutableOnboardingPromptOptionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingPromptOptionData(null, this.id_build(), this.channelsIds_build(), this.rolesIds_build(), this.emoji, this.title, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoji");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build OnboardingPromptOptionData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private List<Id> channelsIds_build() {
            return this.channelsIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> channelsIds_getOrCreate() {
            if (this.channelsIds_list == null) {
                this.channelsIds_list = new ArrayList<Long>();
            }
            return this.channelsIds_list;
        }

        private List<Id> rolesIds_build() {
            return this.rolesIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> rolesIds_getOrCreate() {
            if (this.rolesIds_list == null) {
                this.rolesIds_list = new ArrayList<Long>();
            }
            return this.rolesIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OnboardingPromptOptionData", generator="Immutables")
    static final class Json
    implements OnboardingPromptOptionData {
        Id id;
        List<Id> channelsIds;
        List<Id> rolesIds;
        EmojiData emoji;
        String title;
        Optional<String> description = Optional.empty();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="channel_ids")
        public void setChannelsIds(List<Id> channelsIds) {
            this.channelsIds = channelsIds;
        }

        @JsonProperty(value="role_ids")
        public void setRolesIds(List<Id> rolesIds) {
            this.rolesIds = rolesIds;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(EmojiData emoji) {
            this.emoji = emoji;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> channelsIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> rolesIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmojiData emoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="OnboardingPromptOptionData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingPromptOptionData, attribute initializers form cycle " + attributes;
        }
    }
}

