/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.payload;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.payload.PayloadReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class JacksonPayloadReader
implements PayloadReader {
    private static final Logger log = Loggers.getLogger(JacksonPayloadReader.class);
    private final ObjectMapper mapper;
    private final boolean lenient;

    public JacksonPayloadReader(ObjectMapper mapper) {
        this(mapper, true);
    }

    @Deprecated
    public JacksonPayloadReader(ObjectMapper mapper, boolean lenient) {
        this.mapper = mapper;
        this.lenient = lenient;
    }

    public Mono<GatewayPayload<?>> read(ByteBuf buf) {
        return Mono.create(sink -> {
            sink.onDispose(() -> ReferenceCountUtil.release(buf));
            try {
                GatewayPayload value = (GatewayPayload)this.mapper.readValue(ByteBufUtil.getBytes(buf, buf.readerIndex(), buf.readableBytes(), false), new TypeReference<GatewayPayload<?>>(){});
                sink.success(value);
            }
            catch (IllegalArgumentException e) {
                sink.success();
            }
            catch (IOException e) {
                if (this.lenient) {
                    if (buf.readableBytes() > 0) {
                        log.warn("Error while decoding JSON ({}): {}", e.toString(), new String(ByteBufUtil.getBytes(buf), StandardCharsets.UTF_8));
                    }
                    sink.success();
                }
                sink.error(Exceptions.propagate(e));
            }
        });
    }
}

