/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http.client;

import discord4j.rest.http.ExchangeStrategies;
import discord4j.rest.http.ReaderStrategy;
import discord4j.rest.http.client.ClientException;
import discord4j.rest.http.client.ClientRequest;
import discord4j.rest.json.response.ErrorResponse;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.response.ResponseFunction;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.netty.NettyInbound;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class ClientResponse {
    private static final Logger log = Loggers.getLogger(ClientResponse.class);
    private final HttpClientResponse response;
    private final NettyInbound inbound;
    private final ExchangeStrategies exchangeStrategies;
    private final ClientRequest clientRequest;
    private final List<ResponseFunction> responseFunctions;
    private final AtomicBoolean reject = new AtomicBoolean();

    ClientResponse(HttpClientResponse response, NettyInbound inbound, ExchangeStrategies exchangeStrategies, ClientRequest clientRequest, List<ResponseFunction> responseFunctions) {
        this.response = response;
        this.inbound = inbound;
        this.exchangeStrategies = exchangeStrategies;
        this.clientRequest = clientRequest;
        this.responseFunctions = responseFunctions;
    }

    public HttpClientResponse getHttpResponse() {
        return this.response;
    }

    public Mono<ByteBuf> getBody() {
        return this.inbound.receive().aggregate().doOnSubscribe(s2 -> {
            if (this.reject.get()) {
                throw new IllegalStateException("Response body can only be consumed once");
            }
        }).doOnCancel(() -> this.reject.set(true)).doOnNext(buf -> buf.touch("discord4j.client.response"));
    }

    public <T> Mono<T> bodyToMono(Class<T> responseType) {
        return Mono.defer(() -> {
            if (this.response.status().code() >= 400) {
                return this.createException().flatMap(Mono::error);
            }
            return Mono.just(this);
        }).transform(this.getResponseTransformers(this.clientRequest.getDiscordRequest())).flatMap(res -> {
            String responseContentType = this.response.responseHeaders().get(HttpHeaderNames.CONTENT_TYPE);
            Optional<ReaderStrategy> readerStrategy = this.exchangeStrategies.readers().stream().filter(s2 -> s2.canRead(responseType, responseContentType)).findFirst();
            return readerStrategy.map(ClientResponse::cast).map(s2 -> s2.read(this.getBody(), responseType)).orElseGet(() -> Mono.error(ClientResponse.noReaderException(responseType, responseContentType))).checkpoint("Body from " + this.clientRequest.getDescription() + " [ClientResponse]");
        });
    }

    private Function<Mono<ClientResponse>, Mono<ClientResponse>> getResponseTransformers(DiscordWebRequest discordRequest) {
        return this.responseFunctions.stream().map(rt -> rt.transform(discordRequest).andThen(mono -> mono.checkpoint("Apply " + rt + " to " + discordRequest.getDescription() + " [ClientResponse]"))).reduce(Function::andThen).orElse(mono -> mono);
    }

    public Mono<ClientException> createException() {
        String responseContentType = this.response.responseHeaders().get(HttpHeaderNames.CONTENT_TYPE);
        Optional<ReaderStrategy> readerStrategy = this.exchangeStrategies.readers().stream().filter(s2 -> s2.canRead(ErrorResponse.class, responseContentType)).findFirst();
        return Mono.justOrEmpty(readerStrategy).map(ClientResponse::cast).flatMap(s2 -> s2.read(this.getBody(), ErrorResponse.class)).flatMap(s2 -> Mono.just(ClientResponse.clientException(this.clientRequest, this.response, s2))).switchIfEmpty(Mono.just(ClientResponse.clientException(this.clientRequest, this.response, null))).checkpoint(this.response.status().toString() + " from " + this.clientRequest.getDescription() + " [ClientResponse]");
    }

    public Mono<Void> skipBody() {
        return this.getBody().map(ReferenceCounted::release).then();
    }

    private static <T> ReaderStrategy<T> cast(ReaderStrategy<?> strategy) {
        return strategy;
    }

    private static ClientException clientException(ClientRequest request, HttpClientResponse response, @Nullable ErrorResponse errorResponse) {
        return new ClientException(request, response, errorResponse);
    }

    private static RuntimeException noReaderException(Object body, String contentType) {
        return new RuntimeException("No strategies to read this response: " + body + " - " + contentType);
    }

    public String toString() {
        return "ClientResponse{response=" + this.response + '}';
    }
}

