/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.request.RateLimitStrategy;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.Duration;
import reactor.netty.http.client.HttpClientResponse;

public class ResponseHeaderStrategy
implements RateLimitStrategy {
    @Override
    public Duration apply(HttpClientResponse response) {
        HttpHeaders headers = response.responseHeaders();
        int remaining = headers.getInt("X-RateLimit-Remaining", -1);
        if (remaining == 0) {
            long resetAfter = (long)(Double.parseDouble(headers.get("X-RateLimit-Reset-After")) * 1000.0);
            return Duration.ofMillis(resetAfter);
        }
        return Duration.ZERO;
    }
}

