/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.mapping;

import discord4j.store.api.Store;
import discord4j.store.api.noop.NoOpStoreService;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.StoreContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MappingStoreService
implements StoreService {
    private final Map<Class<?>, StoreService> serviceMap;
    private final StoreService fallback;

    private MappingStoreService(Map<Class<?>, StoreService> serviceMap, @Nullable StoreService fallback) {
        this.serviceMap = serviceMap;
        this.fallback = fallback == null ? new NoOpStoreService() : fallback;
    }

    public static MappingStoreService create() {
        return new MappingStoreService(new ConcurrentHashMap(), null);
    }

    public MappingStoreService setMapping(StoreService storeService, Class<?> valueClass) {
        ConcurrentHashMap updatedMap = new ConcurrentHashMap(this.serviceMap);
        updatedMap.put(valueClass, storeService);
        return new MappingStoreService(updatedMap, this.fallback);
    }

    public MappingStoreService setMappings(StoreService storeService, Class<?> ... valueClasses) {
        ConcurrentHashMap updatedMap = new ConcurrentHashMap(this.serviceMap);
        for (Class<?> valueClass : valueClasses) {
            updatedMap.put(valueClass, storeService);
        }
        return new MappingStoreService(updatedMap, this.fallback);
    }

    public MappingStoreService setFallback(@Nullable StoreService storeService) {
        return new MappingStoreService(this.serviceMap, storeService);
    }

    @Override
    public boolean hasGenericStores() {
        return this.serviceMap.values().stream().anyMatch(StoreService::hasGenericStores) || this.fallback.hasGenericStores();
    }

    @Override
    public <K extends Comparable<K>, V> Store<K, V> provideGenericStore(Class<K> keyClass, Class<V> valueClass) {
        return this.getGenericStore(valueClass).provideGenericStore(keyClass, valueClass);
    }

    private <V> StoreService getGenericStore(Class<V> valueClass) {
        StoreService service = this.serviceMap.getOrDefault(valueClass, this.fallback);
        return service.hasGenericStores() ? service : this.fallback;
    }

    @Override
    public boolean hasLongObjStores() {
        return this.serviceMap.values().stream().anyMatch(StoreService::hasLongObjStores) || this.fallback.hasLongObjStores();
    }

    @Override
    public <V> LongObjStore<V> provideLongObjStore(Class<V> valueClass) {
        return this.getLongObjStore(valueClass).provideLongObjStore(valueClass);
    }

    private <V> StoreService getLongObjStore(Class<V> valueClass) {
        StoreService service = this.serviceMap.getOrDefault(valueClass, this.fallback);
        return service.hasLongObjStores() ? service : this.fallback;
    }

    @Override
    public void init(StoreContext context) {
        this.serviceMap.values().forEach(service -> service.init(context));
        this.fallback.init(context);
    }

    @Override
    public Mono<Void> dispose() {
        return Flux.fromIterable(this.serviceMap.values()).concatWithValues((StoreService[])new StoreService[]{this.fallback}).flatMap(StoreService::dispose).then();
    }
}

