/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.voice.AudioReceiver;
import discord4j.voice.PacketTransformer;
import io.netty.buffer.ByteBuf;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.util.Logger;
import reactor.util.Loggers;

public class LocalVoiceReceiveTask
implements Disposable {
    private static final Logger log = Loggers.getLogger(LocalVoiceReceiveTask.class);
    private final Disposable task;

    public LocalVoiceReceiveTask(Scheduler scheduler, Flux<ByteBuf> in, PacketTransformer transformer, AudioReceiver receiver) {
        this.task = in.flatMap(packet -> Mono.fromCallable(() -> transformer.nextReceive((ByteBuf)packet)).map(buf -> {
            if (receiver != AudioReceiver.NO_OP) {
                receiver.getBuffer().put((byte[])buf);
                receiver.getBuffer().flip();
                receiver.receive();
            }
            return buf;
        }).onErrorResume(t -> {
            log.error("Error while receiving audio", (Throwable)t);
            return Mono.empty();
        })).subscribeOn(scheduler).subscribe();
    }

    @Override
    public void dispose() {
        this.task.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.task.isDisposed();
    }
}

