/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import discord4j.voice.json.HeartbeatAck;
import discord4j.voice.json.Hello;
import discord4j.voice.json.Ready;
import discord4j.voice.json.Resumed;
import discord4j.voice.json.SessionDescription;
import discord4j.voice.json.Speaking;
import discord4j.voice.json.VoiceDisconnect;
import discord4j.voice.json.VoiceGatewayPayload;
import java.io.IOException;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class VoiceGatewayPayloadDeserializer
extends StdDeserializer<VoiceGatewayPayload<?>> {
    private static final Logger LOG = Loggers.getLogger(VoiceGatewayPayloadDeserializer.class);

    public VoiceGatewayPayloadDeserializer() {
        super(VoiceGatewayPayload.class);
    }

    @Override
    @Nullable
    public VoiceGatewayPayload<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode json = (JsonNode)p.getCodec().readTree(p);
        int op = json.get("op").asInt();
        JsonNode d = json.get("d");
        switch (op) {
            case 8: {
                return new Hello(d.get("heartbeat_interval").asLong());
            }
            case 2: {
                return new Ready(d.get("ssrc").asInt(), d.get("ip").asText(), d.get("port").asInt());
            }
            case 6: {
                return new HeartbeatAck(d.asLong());
            }
            case 4: {
                ArrayNode arrayNode = (ArrayNode)d.get("secret_key");
                byte[] secret_key = p.getCodec().readValue(arrayNode.traverse(p.getCodec()), byte[].class);
                return new SessionDescription(d.get("mode").asText(), secret_key);
            }
            case 5: {
                return new Speaking(d.get("user_id").asText(), d.get("ssrc").asInt(), d.get("speaking").asBoolean());
            }
            case 13: {
                return new VoiceDisconnect(d.get("user_id").asText());
            }
            case 9: {
                return new Resumed(d.asText());
            }
        }
        LOG.debug("Received voice gateway payload with unhandled OP: {}", op);
        return null;
    }
}

