/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice.retry;

import discord4j.common.close.CloseException;
import discord4j.common.retry.ReconnectContext;
import discord4j.common.retry.ReconnectOptions;
import discord4j.voice.VoiceConnection;
import discord4j.voice.retry.PartialDisconnectException;
import discord4j.voice.retry.VoiceGatewayReconnectException;
import discord4j.voice.retry.VoiceGatewayRetrySignal;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.retry.Retry;

public class VoiceGatewayRetrySpec
extends Retry {
    public static final List<Integer> NON_RETRYABLE_STATUS_CODES = Arrays.asList(4004, 4006, 4016);
    private static final Consumer<VoiceGatewayRetrySignal> NO_OP_CONSUMER = retrySignal -> {};
    private final ReconnectOptions reconnectOptions;
    private final ReconnectContext reconnectContext;
    private final Consumer<VoiceGatewayRetrySignal> doPreRetry;

    VoiceGatewayRetrySpec(ReconnectOptions reconnectOptions, ReconnectContext reconnectContext, Consumer<VoiceGatewayRetrySignal> doPreRetry) {
        this.reconnectOptions = reconnectOptions;
        this.reconnectContext = reconnectContext;
        this.doPreRetry = doPreRetry;
    }

    public static VoiceGatewayRetrySpec create(ReconnectOptions reconnectOptions, ReconnectContext reconnectContext) {
        return new VoiceGatewayRetrySpec(reconnectOptions, reconnectContext, NO_OP_CONSUMER);
    }

    public VoiceGatewayRetrySpec doBeforeRetry(Consumer<VoiceGatewayRetrySignal> doBeforeRetry) {
        return new VoiceGatewayRetrySpec(this.reconnectOptions, this.reconnectContext, this.doPreRetry.andThen(doBeforeRetry));
    }

    private boolean isRetryable(@Nullable Throwable t) {
        if (t instanceof CloseException) {
            CloseException closeException = (CloseException)t;
            return !NON_RETRYABLE_STATUS_CODES.contains(closeException.getCode());
        }
        return !(t instanceof PartialDisconnectException);
    }

    private boolean canResume(Throwable t) {
        if (t instanceof CloseException) {
            CloseException closeException = (CloseException)t;
            return closeException.getCode() < 4000;
        }
        return !(t instanceof VoiceGatewayReconnectException);
    }

    public Flux<Long> generateCompanion(Flux<Retry.RetrySignal> t) {
        return t.concatMap(retryWhenState -> {
            VoiceConnection.State nextState;
            Duration nextBackoff;
            Retry.RetrySignal copy = retryWhenState.copy();
            Throwable currentFailure = copy.failure();
            if (currentFailure == null) {
                return Mono.error(new IllegalStateException("Retry.RetrySignal#failure() not expected to be null"));
            }
            if (!this.isRetryable(currentFailure)) {
                return Mono.error(currentFailure);
            }
            long iteration = this.reconnectContext.getAttempts();
            if (iteration >= this.reconnectOptions.getMaxRetries()) {
                return Mono.error(Exceptions.retryExhausted("Retries exhausted: " + iteration + "/" + this.reconnectOptions.getMaxRetries(), copy.failure()));
            }
            Duration minBackoff = this.reconnectOptions.getFirstBackoff();
            Duration maxBackoff = this.reconnectOptions.getMaxBackoffInterval();
            if (this.canResume(currentFailure)) {
                nextBackoff = iteration == 1L ? Duration.ZERO : VoiceGatewayRetrySpec.computeBackoff(iteration - 2L, minBackoff, maxBackoff);
                nextState = VoiceConnection.State.RESUMING;
            } else {
                nextBackoff = VoiceGatewayRetrySpec.computeBackoff(iteration - 1L, minBackoff, maxBackoff);
                nextState = VoiceConnection.State.RECONNECTING;
            }
            this.reconnectContext.next();
            if (nextBackoff.isZero()) {
                return VoiceGatewayRetrySpec.applyHooks(new VoiceGatewayRetrySignal(copy.failure(), iteration, nextBackoff, nextState), Mono.just(iteration), this.doPreRetry);
            }
            Duration effectiveBackoff = nextBackoff.plusMillis(VoiceGatewayRetrySpec.computeJitter(nextBackoff, minBackoff, maxBackoff, this.reconnectOptions.getJitterFactor()));
            return VoiceGatewayRetrySpec.applyHooks(new VoiceGatewayRetrySignal(copy.failure(), iteration, effectiveBackoff, nextState), Mono.delay(effectiveBackoff, this.reconnectOptions.getBackoffScheduler()), this.doPreRetry);
        });
    }

    static long computeJitter(Duration nextBackoff, Duration minBackoff, Duration maxBackoff, double factor) {
        long jitterOffset;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            jitterOffset = nextBackoff.multipliedBy((long)(100.0 * factor)).dividedBy(100L).toMillis();
        }
        catch (ArithmeticException ae) {
            jitterOffset = Math.round(9.223372036854776E18 * factor);
        }
        long lowBound = Math.max(minBackoff.minus(nextBackoff).toMillis(), -jitterOffset);
        long highBound = Math.min(maxBackoff.minus(nextBackoff).toMillis(), jitterOffset);
        if (highBound == lowBound) {
            if (highBound == 0L) {
                return 0L;
            }
            return random.nextLong(highBound);
        }
        return random.nextLong(lowBound, highBound);
    }

    static Duration computeBackoff(long iteration, Duration minBackoff, Duration maxBackoff) {
        Duration nextBackoff;
        try {
            nextBackoff = minBackoff.multipliedBy((long)Math.pow(2.0, iteration));
            if (nextBackoff.compareTo(maxBackoff) > 0) {
                nextBackoff = maxBackoff;
            }
        }
        catch (ArithmeticException overflow) {
            nextBackoff = maxBackoff;
        }
        return nextBackoff;
    }

    static <T> Mono<T> applyHooks(VoiceGatewayRetrySignal retrySignal, Mono<T> originalCompanion, Consumer<VoiceGatewayRetrySignal> doPreRetry) {
        if (doPreRetry != NO_OP_CONSUMER) {
            try {
                doPreRetry.accept(retrySignal);
            }
            catch (Throwable e) {
                return Mono.error(e);
            }
        }
        return originalCompanion;
    }
}

