/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http;

import com.gmail.berndivader.biene.http.ProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;

public class ProgressFileEntity
extends FileEntity {
    private final ProgressListener listener;

    public ProgressFileEntity(File file, ContentType type, ProgressListener listener) {
        super(file, type);
        this.listener = listener;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        try (FileInputStream filestream = new FileInputStream(this.file);){
            int read;
            byte[] buffer = new byte[4096];
            long totalbytes = this.file.length();
            long transferred = 0L;
            while ((read = filestream.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                this.listener.progress(transferred += (long)read, totalbytes);
            }
        }
    }
}

