/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Mentions;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageActivity;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.attribute.ICategorizableChannel;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.dv8tion.jda.api.entities.sticker.StickerItem;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.Route;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.MarkdownSanitizer;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.CompletedRestAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.MessageEditActionImpl;
import net.dv8tion.jda.internal.requests.restaction.pagination.ReactionPaginationActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.EncodingUtil;
import net.dv8tion.jda.internal.utils.EntityString;
import net.dv8tion.jda.internal.utils.Helpers;

public class ReceivedMessage
implements Message {
    public static boolean didContentIntentWarning = false;
    private final Object mutex = new Object();
    protected final JDAImpl api;
    protected final long id;
    protected final long channelId;
    protected final long guildId;
    protected final long applicationId;
    protected final int flags;
    protected final int position;
    protected final boolean fromWebhook;
    protected final boolean pinned;
    protected final boolean isTTS;
    protected final MessageType type;
    protected final MessageChannel channel;
    protected final Guild guild;
    protected final MessageReference messageReference;
    protected final User author;
    protected final Member member;
    protected final String content;
    protected final String nonce;
    protected final MessageActivity activity;
    protected final OffsetDateTime editedTime;
    protected final Mentions mentions;
    protected final Message.Interaction interaction;
    protected final ThreadChannel startedThread;
    protected final List<MessageReaction> reactions;
    protected final List<Message.Attachment> attachments;
    protected final List<MessageEmbed> embeds;
    protected final List<StickerItem> stickers;
    protected final List<LayoutComponent> components;
    protected WebhookClient<Message> webhook;
    protected String altContent = null;
    protected String strippedContent = null;
    protected List<String> invites = null;

    public ReceivedMessage(long id, long channelId, long guildId, JDA jda, Guild guild, MessageChannel channel, MessageType type, MessageReference messageReference, boolean fromWebhook, long applicationId, boolean tts, boolean pinned, String content, String nonce, User author, Member member, MessageActivity activity, OffsetDateTime editTime, Mentions mentions, List<MessageReaction> reactions, List<Message.Attachment> attachments, List<MessageEmbed> embeds, List<StickerItem> stickers, List<ActionRow> components, int flags, Message.Interaction interaction, ThreadChannel startedThread, int position) {
        this.id = id;
        this.channelId = channelId;
        this.channel = channel;
        this.guildId = guildId;
        this.guild = guild;
        this.messageReference = messageReference;
        this.type = type;
        this.api = (JDAImpl)jda;
        this.fromWebhook = fromWebhook;
        this.applicationId = applicationId;
        this.pinned = pinned;
        this.content = content;
        this.nonce = nonce;
        this.isTTS = tts;
        this.author = author;
        this.member = member;
        this.activity = activity;
        this.editedTime = editTime;
        this.mentions = mentions;
        this.reactions = Collections.unmodifiableList(reactions);
        this.attachments = Collections.unmodifiableList(attachments);
        this.embeds = Collections.unmodifiableList(embeds);
        this.stickers = Collections.unmodifiableList(stickers);
        this.components = Collections.unmodifiableList(components);
        this.flags = flags;
        this.interaction = interaction;
        this.startedThread = startedThread;
        this.position = position;
    }

    private void checkSystem(String comment) {
        if (this.type.isSystem()) {
            throw new IllegalStateException("Cannot " + comment + " a system message!");
        }
    }

    private void checkUser() {
        if (!this.getJDA().getSelfUser().equals(this.getAuthor())) {
            throw new IllegalStateException("Attempted to update message that was not sent by this account. You cannot modify other User's messages!");
        }
    }

    private void checkIntent() {
        SelfUser selfUser;
        if (!(didContentIntentWarning || this.api.isIntent(GatewayIntent.MESSAGE_CONTENT) || Objects.equals(selfUser = this.api.getSelfUser(), this.author) || this.mentions.getUsers().contains(selfUser) || !this.isFromGuild())) {
            didContentIntentWarning = true;
            JDAImpl.LOG.warn("Attempting to access message content without GatewayIntent.MESSAGE_CONTENT.\nDiscord now requires to explicitly enable access to this using the MESSAGE_CONTENT intent.\nUseful resources to learn more:\n\t- https://support-dev.discord.com/hc/en-us/articles/4404772028055-Message-Content-Privileged-Intent-FAQ\n\t- https://jda.wiki/using-jda/gateway-intents-and-member-cache-policy/\n\t- https://jda.wiki/using-jda/troubleshooting/#cannot-get-message-content-attempting-to-access-message-content-without-gatewayintent\nOr suppress this warning if this is intentional with Message.suppressContentIntentWarning()");
        }
    }

    public ReceivedMessage withHook(WebhookClient<Message> hook) {
        this.webhook = hook;
        return this;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nullable
    public MessageReference getMessageReference() {
        return this.messageReference;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    @Nonnull
    public RestAction<Void> pin() {
        this.checkSystem("pin");
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot pin ephemeral messages.");
        }
        if (this.hasChannel()) {
            return this.getChannel().pinMessageById(this.getIdLong());
        }
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getChannelId(), this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public RestAction<Void> unpin() {
        this.checkSystem("unpin");
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot unpin ephemeral messages.");
        }
        if (this.hasChannel()) {
            return this.getChannel().unpinMessageById(this.getIdLong());
        }
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getChannelId(), this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public RestAction<Void> addReaction(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot add reactions to ephemeral messages.");
        }
        Checks.notNull(emoji, "Emoji");
        if (this.hasChannel()) {
            boolean missingReaction = this.reactions.stream().map(MessageReaction::getEmoji).noneMatch(r -> r.getAsReactionCode().equals(emoji.getAsReactionCode()));
            if (missingReaction && emoji instanceof RichCustomEmoji) {
                Checks.check(((RichCustomEmoji)emoji).canInteract(this.getJDA().getSelfUser(), this.getChannel()), "Cannot react with the provided emoji because it is not available in the current getChannel().");
            }
            return this.getChannel().addReactionById(this.getId(), emoji);
        }
        String encoded = EncodingUtil.encodeReaction(emoji.getAsReactionCode());
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getChannelId(), this.getId(), encoded, "@me");
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public RestAction<Void> clearReactions() {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot clear reactions from ephemeral messages.");
        }
        if (!this.isFromGuild()) {
            throw new IllegalStateException("Cannot clear reactions from a message in a Group or PrivateChannel.");
        }
        if (this.channel instanceof GuildMessageChannel) {
            return ((GuildMessageChannel)this.channel).clearReactionsById(this.getId());
        }
        Route.CompiledRoute route = Route.Messages.REMOVE_ALL_REACTIONS.compile(this.getChannelId(), this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public RestAction<Void> clearReactions(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot clear reactions from ephemeral messages.");
        }
        if (!this.isFromGuild()) {
            throw new IllegalStateException("Cannot clear reactions from a message in a Group or PrivateChannel.");
        }
        if (this.channel instanceof GuildMessageChannel) {
            return ((GuildMessageChannel)this.channel).clearReactionsById(this.getId(), emoji);
        }
        String encoded = EncodingUtil.encodeReaction(emoji.getAsReactionCode());
        Route.CompiledRoute route = Route.Messages.CLEAR_EMOJI_REACTIONS.compile(this.getChannelId(), this.getId(), encoded);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public RestAction<Void> removeReaction(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot remove reactions from ephemeral messages.");
        }
        if (this.hasChannel()) {
            return this.getChannel().removeReactionById(this.getId(), emoji);
        }
        String encoded = EncodingUtil.encodeReaction(emoji.getAsReactionCode());
        Route.CompiledRoute route = Route.Messages.REMOVE_REACTION.compile(this.getChannelId(), this.getId(), encoded, "@me");
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public RestAction<Void> removeReaction(@Nonnull Emoji emoji, @Nonnull User user) {
        Checks.notNull(user, "User");
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot remove reactions from ephemeral messages.");
        }
        if (user.equals(this.getJDA().getSelfUser())) {
            return this.removeReaction(emoji);
        }
        if (!this.isFromGuild()) {
            throw new IllegalStateException("Cannot remove reactions of others from a message in a Group or PrivateChannel.");
        }
        if (this.channel instanceof GuildMessageChannel) {
            return ((GuildMessageChannel)this.channel).removeReactionById(this.getIdLong(), emoji, user);
        }
        String encoded = EncodingUtil.encodeReaction(emoji.getAsReactionCode());
        Route.CompiledRoute route = Route.Messages.REMOVE_REACTION.compile(this.getChannelId(), this.getId(), encoded, user.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public ReactionPaginationAction retrieveReactionUsers(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot retrieve reactions on ephemeral messages.");
        }
        if (this.hasChannel()) {
            return this.getChannel().retrieveReactionUsersById(this.id, emoji);
        }
        return new ReactionPaginationActionImpl(this, emoji.getAsReactionCode());
    }

    @Override
    @Nullable
    public MessageReaction getReaction(@Nonnull Emoji emoji) {
        Checks.notNull(emoji, "Emoji");
        String code = emoji.getAsReactionCode();
        return this.reactions.stream().filter(r -> code.equals(r.getEmoji().getAsReactionCode())).findFirst().orElse(null);
    }

    @Override
    @Nonnull
    public MessageType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Message.Interaction getInteraction() {
        return this.interaction;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getJumpUrl() {
        return Helpers.format("https://discord.com/channels/%s/%s/%s", this.isFromGuild() ? this.getGuildId() : "@me", this.getChannelId(), this.getId());
    }

    @Override
    public boolean isEdited() {
        return this.editedTime != null;
    }

    @Override
    public OffsetDateTime getTimeEdited() {
        return this.editedTime;
    }

    @Override
    @Nonnull
    public User getAuthor() {
        return this.author;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public int getApproximatePosition() {
        if (!this.getChannelType().isThread()) {
            throw new IllegalStateException("This message was not sent in a thread.");
        }
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String getContentStripped() {
        if (this.strippedContent != null) {
            return this.strippedContent;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.strippedContent != null) {
                return this.strippedContent;
            }
            this.strippedContent = MarkdownSanitizer.sanitize(this.getContentDisplay());
            return this.strippedContent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String getContentDisplay() {
        if (this.altContent != null) {
            return this.altContent;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.altContent != null) {
                return this.altContent;
            }
            String tmp = this.getContentRaw();
            for (User user : this.mentions.getUsers()) {
                String name = this.hasGuild() && this.getGuild().isMember(user) ? this.getGuild().getMember(user).getEffectiveName() : user.getName();
                tmp = tmp.replaceAll("<@!?" + Pattern.quote(user.getId()) + '>', '@' + Matcher.quoteReplacement(name));
            }
            for (CustomEmoji emoji : this.mentions.getCustomEmojis()) {
                tmp = tmp.replace(emoji.getAsMention(), ":" + emoji.getName() + ":");
            }
            for (GuildChannel mentionedChannel : this.mentions.getChannels()) {
                tmp = tmp.replace(mentionedChannel.getAsMention(), '#' + mentionedChannel.getName());
            }
            for (Role mentionedRole : this.mentions.getRoles()) {
                tmp = tmp.replace(mentionedRole.getAsMention(), '@' + mentionedRole.getName());
            }
            this.altContent = tmp;
            return this.altContent;
        }
    }

    @Override
    @Nonnull
    public String getContentRaw() {
        this.checkIntent();
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<String> getInvites() {
        if (this.invites != null) {
            return this.invites;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.invites != null) {
                return this.invites;
            }
            this.invites = new ArrayList<String>();
            Matcher m = INVITE_PATTERN.matcher(this.getContentRaw());
            while (m.find()) {
                this.invites.add(m.group(1));
            }
            this.invites = Collections.unmodifiableList(this.invites);
            return this.invites;
        }
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isFromType(@Nonnull ChannelType type) {
        return this.getChannelType() == type;
    }

    @Override
    public boolean isFromGuild() {
        return this.guildId != 0L;
    }

    @Override
    @Nonnull
    public ChannelType getChannelType() {
        return this.channel == null ? ChannelType.UNKNOWN : this.getChannel().getType();
    }

    @Override
    @Nonnull
    public MessageChannelUnion getChannel() {
        if (this.channel != null) {
            return (MessageChannelUnion)this.channel;
        }
        throw new IllegalStateException("Channel is unavailable in this context. Use getChannelIdLong() instead!");
    }

    @Override
    @Nonnull
    public GuildMessageChannelUnion getGuildChannel() {
        if (this.channel == null || this.channel instanceof GuildMessageChannelUnion) {
            return (GuildMessageChannelUnion)((Object)this.getChannel());
        }
        throw new IllegalStateException("This message was not sent in a guild.");
    }

    @Override
    public Category getCategory() {
        Channel channel = this.channel;
        if (channel instanceof ThreadChannel) {
            channel = ((ThreadChannel)channel).getParentChannel();
        }
        return channel instanceof ICategorizableChannel ? ((ICategorizableChannel)channel).getParentCategory() : null;
    }

    @Override
    public boolean hasGuild() {
        return this.guild != null;
    }

    @Override
    public long getGuildIdLong() {
        return this.guildId;
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        if (this.guild == null) {
            ChannelType channelType = this.getChannelType();
            if (channelType == ChannelType.UNKNOWN || channelType.isGuild()) {
                throw new IllegalStateException("This message instance does not provide a guild instance! Use getGuildId() instead.");
            }
            throw new IllegalStateException("This message was not sent in a guild");
        }
        return this.guild;
    }

    @Override
    @Nonnull
    public List<Message.Attachment> getAttachments() {
        this.checkIntent();
        return this.attachments;
    }

    @Override
    @Nonnull
    public List<MessageEmbed> getEmbeds() {
        this.checkIntent();
        return this.embeds;
    }

    @Override
    @Nonnull
    public List<LayoutComponent> getComponents() {
        this.checkIntent();
        return this.components;
    }

    @Override
    @Nonnull
    public Mentions getMentions() {
        return this.mentions;
    }

    @Override
    @Nonnull
    public List<MessageReaction> getReactions() {
        return this.reactions;
    }

    @Override
    @Nonnull
    public List<StickerItem> getStickers() {
        return this.stickers;
    }

    @Override
    public boolean isWebhookMessage() {
        return this.fromWebhook;
    }

    @Override
    public long getApplicationIdLong() {
        return this.applicationId;
    }

    @Override
    public boolean hasChannel() {
        return this.channel != null;
    }

    @Override
    public long getChannelIdLong() {
        return this.channelId;
    }

    @Override
    public boolean isTTS() {
        return this.isTTS;
    }

    @Override
    @Nullable
    public MessageActivity getActivity() {
        return this.activity;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessage(@Nonnull CharSequence newContent) {
        MessageEditActionImpl action = this.editRequest();
        action.setContent(newContent.toString());
        if (this.isWebhookRequest()) {
            return action.withHook(this.webhook);
        }
        this.checkSystem("edit");
        this.checkUser();
        return (MessageEditAction)action.setContent(newContent.toString());
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        MessageEditActionImpl action = this.editRequest();
        action.setEmbeds(embeds);
        if (this.isWebhookRequest()) {
            return action.withHook(this.webhook);
        }
        this.checkSystem("edit");
        this.checkUser();
        return action;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageComponents(@Nonnull Collection<? extends LayoutComponent> components) {
        MessageEditActionImpl action = this.editRequest();
        action.setComponents(components);
        if (this.isWebhookRequest()) {
            return action.withHook(this.webhook);
        }
        this.checkSystem("edit");
        this.checkUser();
        return action;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageFormat(@Nonnull String format, Object ... args2) {
        MessageEditActionImpl action = this.editRequest();
        action.setContent(String.format(format, args2));
        if (this.isWebhookRequest()) {
            return action.withHook(this.webhook);
        }
        this.checkSystem("edit");
        this.checkUser();
        return action;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageAttachments(@Nonnull Collection<? extends AttachedFile> attachments) {
        MessageEditActionImpl action = this.editRequest();
        action.setAttachments(attachments);
        if (this.isWebhookRequest()) {
            return action.withHook(this.webhook);
        }
        this.checkSystem("edit");
        this.checkUser();
        return action;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessage(@Nonnull MessageEditData newContent) {
        MessageEditActionImpl action = this.editRequest();
        action.applyData(newContent);
        if (this.isWebhookRequest()) {
            return action.withHook(this.webhook);
        }
        this.checkSystem("edit");
        this.checkUser();
        return action;
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        if (!this.type.canDelete()) {
            throw new IllegalStateException("Cannot delete messages of type " + (Object)((Object)this.type));
        }
        if (this.isWebhookRequest()) {
            Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK_DELETE.compile(this.webhook.getId(), this.webhook.getToken(), this.getId());
            return new AuditableRestActionImpl<Void>(this.getJDA(), route);
        }
        SelfUser self = this.getJDA().getSelfUser();
        boolean isSelfAuthored = self.equals(this.getAuthor());
        if (!isSelfAuthored && !this.isFromGuild()) {
            throw new IllegalStateException("Cannot delete another User's messages in a PrivateChannel.");
        }
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot delete ephemeral messages.");
        }
        if (this.channel instanceof GuildMessageChannel && !isSelfAuthored) {
            GuildMessageChannel gChan = (GuildMessageChannel)this.channel;
            Member sMember = this.getGuild().getSelfMember();
            Checks.checkAccess(sMember, gChan);
            if (!sMember.hasPermission((GuildChannel)gChan, Permission.MESSAGE_MANAGE)) {
                throw new InsufficientPermissionException(gChan, Permission.MESSAGE_MANAGE);
            }
        }
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getChannelId(), this.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> suppressEmbeds(boolean suppressed) {
        Route.CompiledRoute route;
        SelfUser self = this.api.getSelfUser();
        if (this.isWebhookRequest()) {
            route = Route.Webhooks.EXECUTE_WEBHOOK_DELETE.compile(this.webhook.getId(), this.webhook.getToken(), this.getId());
        } else {
            if (this.isEphemeral()) {
                throw new IllegalStateException("Cannot suppress embeds on ephemeral messages.");
            }
            if (!self.equals(this.getAuthor())) {
                if (!this.isFromGuild()) {
                    throw new PermissionException("Cannot suppress embeds of others in a PrivateChannel.");
                }
                if (this.hasChannel()) {
                    GuildMessageChannelUnion gChan = this.getGuildChannel();
                    if (!this.getGuild().getSelfMember().hasPermission((GuildChannel)gChan, Permission.MESSAGE_MANAGE)) {
                        throw new InsufficientPermissionException(gChan, Permission.MESSAGE_MANAGE);
                    }
                }
            }
            route = Route.Messages.EDIT_MESSAGE.compile(this.getChannelId(), this.getId());
        }
        int newFlags = this.flags;
        int suppressionValue = Message.MessageFlag.EMBEDS_SUPPRESSED.getValue();
        newFlags = suppressed ? (newFlags |= suppressionValue) : (newFlags &= ~suppressionValue);
        DataObject body = DataObject.empty().put("flags", newFlags);
        return new AuditableRestActionImpl<Void>((JDA)this.api, route, body);
    }

    @Override
    @Nonnull
    public RestAction<Message> crosspost() {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot crosspost ephemeral messages.");
        }
        if (this.getFlags().contains((Object)Message.MessageFlag.CROSSPOSTED)) {
            return new CompletedRestAction<Message>(this.getJDA(), this);
        }
        if (!this.hasChannel()) {
            Route.CompiledRoute route = Route.Messages.CROSSPOST_MESSAGE.compile(this.getChannelId(), this.getId());
            return new RestActionImpl<Message>((JDA)this.api, route, (response, request) -> this.api.getEntityBuilder().createMessageFromWebhook(response.getObject(), this.guild));
        }
        MessageChannelUnion channel = this.getChannel();
        if (!(channel instanceof NewsChannel)) {
            throw new IllegalStateException("This message was not sent in a news channel");
        }
        NewsChannel newsChannel = (NewsChannel)((Object)channel);
        Checks.checkAccess(this.getGuild().getSelfMember(), newsChannel);
        if (!this.getAuthor().equals(this.getJDA().getSelfUser()) && !this.getGuild().getSelfMember().hasPermission((GuildChannel)newsChannel, Permission.MESSAGE_MANAGE)) {
            throw new InsufficientPermissionException(newsChannel, Permission.MESSAGE_MANAGE);
        }
        return newsChannel.crosspostMessageById(this.getId());
    }

    @Override
    public boolean isSuppressedEmbeds() {
        return (this.flags & Message.MessageFlag.EMBEDS_SUPPRESSED.getValue()) > 0;
    }

    @Override
    @Nonnull
    public EnumSet<Message.MessageFlag> getFlags() {
        return Message.MessageFlag.fromBitField(this.flags);
    }

    @Override
    public long getFlagsRaw() {
        return this.flags;
    }

    @Override
    public boolean isEphemeral() {
        return (this.flags & Message.MessageFlag.EPHEMERAL.getValue()) != 0;
    }

    @Override
    public boolean isSuppressedNotifications() {
        return (this.flags & Message.MessageFlag.NOTIFICATIONS_SUPPRESSED.getValue()) != 0;
    }

    @Override
    @Nullable
    public ThreadChannel getStartedThread() {
        return this.startedThread;
    }

    @Override
    public ThreadChannelAction createThreadChannel(String name) {
        return this.getGuildChannel().asThreadContainer().createThreadChannel(name, this.getIdLong());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceivedMessage)) {
            return false;
        }
        ReceivedMessage oMsg = (ReceivedMessage)o;
        return this.id == oMsg.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return new EntityString(this).addMetadata("author", this.author.getDiscriminator().equals("0000") ? this.author.getName() : this.author.getAsTag()).addMetadata("content", String.format("%.20s ...", this)).toString();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String out;
        boolean upper = (flags & 2) == 2;
        boolean leftJustified = (flags & 1) == 1;
        boolean alt = (flags & 4) == 4;
        String string = out = alt ? this.getContentRaw() : this.getContentDisplay();
        if (upper) {
            out = out.toUpperCase(formatter.locale());
        }
        try {
            Appendable appendable = formatter.out();
            if (precision > -1 && out.length() > precision) {
                appendable.append(Helpers.truncate(out, precision - 3)).append("...");
                return;
            }
            if (leftJustified) {
                appendable.append(Helpers.rightPad(out, width));
            } else {
                appendable.append(Helpers.leftPad(out, width));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isWebhookRequest() {
        return this.webhook != null && (!(this.webhook instanceof InteractionHook) || !((InteractionHook)this.webhook).isExpired());
    }

    @Nonnull
    private MessageEditActionImpl editRequest() {
        return this.hasChannel() ? new MessageEditActionImpl(this.getChannel(), this.getId()) : new MessageEditActionImpl(this.getJDA(), this.hasGuild() ? this.getGuild() : null, this.getChannelId(), this.getId());
    }
}

