/*
 * Decompiled with CFR 0.152.
 */
package io.github.furstenheim;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jsoup.nodes.Node;

class Rule {
    private Predicate<Node> filter;
    private BiFunction<String, Node, String> replacement;
    private Supplier<String> append = null;
    private String name;

    public Supplier<String> getAppend() {
        return this.append;
    }

    public void setName(String name) {
        this.name = name;
    }

    Rule(String filter, BiFunction<String, Node, String> replacement) {
        this.filter = el -> el.nodeName().toLowerCase() == filter;
        this.replacement = replacement;
    }

    Rule(String[] filters, BiFunction<String, Node, String> replacement) {
        HashSet<String> availableFilters = new HashSet<String>(Arrays.asList(filters));
        this.filter = element -> availableFilters.contains(element.nodeName());
        this.replacement = replacement;
    }

    Rule(Predicate<Node> filter, BiFunction<String, Node, String> replacement) {
        this.filter = filter;
        this.replacement = replacement;
    }

    Rule(Predicate<Node> filter, BiFunction<String, Node, String> replacement, Supplier<String> append) {
        this.filter = filter;
        this.replacement = replacement;
        this.append = append;
    }

    Predicate<Node> getFilter() {
        return this.filter;
    }

    BiFunction<String, Node, String> getReplacement() {
        return this.replacement;
    }
}

