/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

@ExternalAnnotation(name="customvelocity", author="BerndiVader")
public class CustomVelocityMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected double velocityX;
    protected double velocityY;
    protected double velocityZ;
    protected boolean debug;
    private char c;

    public CustomVelocityMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.debug = mlc.getBoolean("debug", false);
        this.velocityX = mlc.getDouble(new String[]{"velocityx", "vx", "x"}, 0.0);
        this.velocityY = mlc.getDouble(new String[]{"velocityy", "vy", "y"}, 0.0);
        this.velocityZ = mlc.getDouble(new String[]{"velocityz", "vz", "z"}, 0.0);
        this.c = mlc.getString(new String[]{"mode", "m"}, "SET", new String[0]).toUpperCase().charAt(0);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity e = target.getBukkitEntity();
        Vector v = e.getVelocity().clone();
        Vector vb = v.clone();
        switch (this.c) {
            case 'A': {
                v.setX(v.getX() + this.velocityX);
                v.setY(v.getY() + this.velocityY);
                v.setZ(v.getZ() + this.velocityZ);
                break;
            }
            case 'M': {
                v.setX(v.getX() * this.velocityX);
                v.setY(v.getY() * this.velocityY);
                v.setZ(v.getZ() * this.velocityZ);
                break;
            }
            default: {
                v = new Vector(this.velocityX, this.velocityY, this.velocityZ);
            }
        }
        if (this.debug) {
            System.out.println("dx:" + v.getX() + " dy:" + v.getY() + " dz:" + v.getZ() + " len:" + v.length());
        }
        if (Double.isNaN(v.length()) || Double.isInfinite(v.length())) {
            v = vb;
        }
        e.setVelocity(v);
        return true;
    }
}

