/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@ExternalAnnotation(name="exchange,exchangeweaponry", author="BerndiVader")
public class ExchangeWeaponry
extends SkillMechanic
implements ITargetedEntitySkill {
    private final String destination;
    private final String where;

    public ExchangeWeaponry(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.destination = mlc.getString(new String[]{"destination", "d"}, "OFFHAND", new String[0]);
        this.where = mlc.getString(new String[]{"where", "w"}, "HAND", new String[0]);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isLiving()) {
            return false;
        }
        LivingEntity entity = (LivingEntity)target.getBukkitEntity();
        EntityEquipment equipment = entity.getEquipment();
        switch (this.destination) {
            case "HAND": {
                equipment.setItemInMainHand(this.getItem(this.where, equipment, true));
                break;
            }
            case "OFFHAND": {
                equipment.setItemInOffHand(this.getItem(this.where, equipment, true));
                break;
            }
            case "HELMET": {
                equipment.setHelmet(this.getItem(this.where, equipment, true));
                break;
            }
            case "CHESTPLATE": {
                equipment.setChestplate(this.getItem(this.where, equipment, true));
                break;
            }
            case "LEGGINGS": {
                equipment.setLeggings(this.getItem(this.where, equipment, true));
                break;
            }
            case "BOOTS": {
                equipment.setBoots(this.getItem(this.where, equipment, true));
            }
        }
        return true;
    }

    static boolean isValidMaterial(ItemStack stack) {
        return stack != null && stack.getType() != Material.AIR;
    }

    public ItemStack getItem(String where, EntityEquipment equipment, boolean replace) {
        ItemStack iS = null;
        switch (where) {
            case "HAND": {
                iS = equipment.getItemInMainHand().clone();
                if (!replace) break;
                equipment.setItemInMainHand(this.getItem(this.destination, equipment, false));
                break;
            }
            case "OFFHAND": {
                iS = equipment.getItemInOffHand().clone();
                if (!replace) break;
                equipment.setItemInOffHand(this.getItem(this.destination, equipment, false));
                break;
            }
            case "HELMET": {
                iS = equipment.getHelmet().clone();
                if (!replace) break;
                equipment.setHelmet(this.getItem(this.destination, equipment, false));
                break;
            }
            case "CHESTPLATE": {
                iS = equipment.getChestplate().clone();
                if (!replace) break;
                equipment.setChestplate(this.getItem(this.destination, equipment, false));
                break;
            }
            case "LEGGINGS": {
                iS = equipment.getLeggings().clone();
                if (!replace) break;
                equipment.setLeggings(this.getItem(this.destination, equipment, false));
                break;
            }
            case "BOOTS": {
                iS = equipment.getBoots().clone();
                if (!replace) break;
                equipment.setBoots(this.getItem(this.destination, equipment, false));
            }
        }
        return iS;
    }
}

