/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.items.ModdingItem;
import com.gmail.berndivader.mythicmobsext.items.WhereEnum;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@ExternalAnnotation(name="modifyloreline", author="nicochulo2001")
public class ModifyLoreLine
extends SkillMechanic
implements ITargetedEntitySkill {
    ModdingItem moddingItem;
    String loreLine;
    PlaceholderString loreTextUnprocessed;
    String loreAction;

    public ModifyLoreLine(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String slot = mlc.getString(new String[]{"slot", "s"}, "-1", new String[0]);
        String what = mlc.getString(new String[]{"what", "w"}, "HAND", new String[0]).toUpperCase();
        String bag = mlc.getString(new String[]{"bagname", "name", "bag", "b", "n"}, null, new String[0]);
        this.loreLine = mlc.getString(new String[]{"loreline", "line", "l"}, null, new String[0]);
        this.loreTextUnprocessed = new PlaceholderString(mlc.getString(new String[]{"loretext", "text", "t"}, null, new String[0]));
        this.loreAction = mlc.getString(new String[]{"loreaction", "action", "a"}, "SET", new String[0]).toUpperCase();
        WhereEnum where = WhereEnum.valueOf(what);
        ModdingItem.ACTION action = ModdingItem.ACTION.SET;
        if (this.loreTextUnprocessed == null || this.loreLine == null) {
            return;
        }
        this.moddingItem = new ModdingItem(where, slot, action, null, null, null, null, null, null, bag, null);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isLiving()) {
            List loreArray;
            LivingEntity entity = (LivingEntity)target.getBukkitEntity();
            ItemStack itemStack = this.moddingItem.getItemStackByWhere(data, target, entity);
            ItemMeta itemMeta = itemStack.getItemMeta();
            int line = Integer.parseInt(this.loreLine);
            if (itemMeta.hasLore() && (loreArray = itemMeta.getLore()).size() > line) {
                String lore = (String)loreArray.get(line);
                String loreText = this.loreTextUnprocessed.get((PlaceholderMeta)data, target);
                switch (this.loreAction) {
                    case "SET": {
                        lore = loreText;
                        break;
                    }
                    case "INSERT": {
                        lore = loreText + lore;
                        break;
                    }
                    case "APPEND": {
                        lore = lore + loreText;
                        break;
                    }
                    case "DEL": {
                        lore = lore.replace(loreText, "");
                        break;
                    }
                    case "REMOVE": {
                        loreArray.remove(line);
                    }
                }
                if (!this.loreAction.equals("REMOVE")) {
                    loreArray.set(line, lore);
                }
                itemMeta.setLore(loreArray);
                itemStack.setItemMeta(itemMeta);
            }
            if (itemStack != null) {
                itemStack = this.moddingItem.applyMods(data, target, itemStack);
            }
            if (target.getBukkitEntity() instanceof Player) {
                ((Player)target.getBukkitEntity()).updateInventory();
            }
            return true;
        }
        return false;
    }
}

