/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.cachedowners;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.cachedowners.CachedOwnerSkill;
import com.gmail.berndivader.mythicmobsext.cachedowners.RestoreCachedOwnerMechanic;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicReloadedEvent;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CachedOwnerHandler
implements Listener {
    protected static final Plugin plugin = Main.getPlugin();
    protected static final MobManager mobmanager = Utils.mobmanager;
    protected static final String cacheFileName = "CachedOwners.txt";
    protected static ConcurrentHashMap<UUID, UUID> cachedOwners;
    protected static File dir;

    public CachedOwnerHandler(Plugin plugin) {
        dir = CachedOwnerHandler.plugin.getDataFolder();
        if (!CachedOwnerHandler.chkDir()) {
            CachedOwnerHandler.createDir();
            CachedOwnerHandler.saveCachedOwners();
            cachedOwners = new ConcurrentHashMap();
        } else {
            cachedOwners = CachedOwnerHandler.loadCachedOwners();
        }
        Main.pluginmanager.registerEvents((Listener)this, plugin);
        new BukkitRunnable(){

            public void run() {
                CachedOwnerHandler.restoreMobOwners();
            }
        }.runTaskLater((Plugin)Main.getPlugin(), 20L);
    }

    @EventHandler
    public void onMythicLoad(MythicMechanicLoadEvent e) {
        String mechanicsName;
        switch (mechanicsName = e.getMechanicName().toLowerCase()) {
            case "setcachedowner": {
                e.register((SkillMechanic)new CachedOwnerSkill(e.getContainer().getConfigLine(), e.getConfig()));
                break;
            }
            case "restorecachedowner": {
                e.register((SkillMechanic)new RestoreCachedOwnerMechanic(e.getContainer().getConfigLine(), e.getConfig()));
            }
        }
    }

    @EventHandler
    public void onMythicReloaded(MythicReloadedEvent e) {
        CachedOwnerHandler.restoreMobOwners();
    }

    public static UUID getMobOwner(UUID slave_uuid) {
        if (cachedOwners.isEmpty() || !cachedOwners.containsKey(slave_uuid)) {
            return null;
        }
        return cachedOwners.get(slave_uuid);
    }

    public static void restoreMobOwners() {
        if (cachedOwners.isEmpty()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry<UUID, UUID> entry : cachedOwners.entrySet()) {
                    UUID owner = entry.getValue();
                    UUID slave = entry.getKey();
                    if (!mobmanager.isActiveMob(slave)) continue;
                    ActiveMob am = (ActiveMob)mobmanager.getActiveMob(slave).get();
                    am.setOwner(owner);
                }
            }
        }.runTaskAsynchronously(plugin);
    }

    public static void addCachedOwner(UUID slave, UUID owner) {
        if (cachedOwners.containsKey(slave)) {
            cachedOwners.replace(slave, owner);
        } else {
            cachedOwners.put(slave, owner);
        }
    }

    public static void removeCachedOwner(UUID slave) {
        if (cachedOwners.containsKey(slave)) {
            cachedOwners.remove(slave);
        }
    }

    public static ConcurrentHashMap<UUID, UUID> loadCachedOwners() {
        ConcurrentHashMap<UUID, UUID> cachedOwners = new ConcurrentHashMap<UUID, UUID>();
        try (Scanner scanner = new Scanner(new InputStreamReader((InputStream)new FileInputStream(dir + System.getProperty("file.separator") + cacheFileName), StandardCharsets.UTF_8));){
            while (scanner.hasNext()) {
                String[] parse = scanner.next().split(";");
                if (parse.length != 2) continue;
                UUID suuid = UUID.fromString(parse[0]);
                UUID muuid = UUID.fromString(parse[1]);
                cachedOwners.put(suuid, muuid);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cachedOwners;
    }

    public static void cleanUp() {
        if (cachedOwners.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, UUID> entry : cachedOwners.entrySet()) {
            if (mobmanager.isActiveMob(entry.getKey())) continue;
            CachedOwnerHandler.removeCachedOwner(entry.getKey());
        }
    }

    public static void saveCachedOwners() {
        if (cachedOwners == null) {
            cachedOwners = new ConcurrentHashMap();
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dir + System.getProperty("file.separator") + cacheFileName), StandardCharsets.UTF_8));){
            ((Writer)writer).flush();
            for (Map.Entry<UUID, UUID> entry : cachedOwners.entrySet()) {
                String p = entry.getKey().toString() + ";" + entry.getValue().toString() + "\n";
                writer.append(p);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static boolean chkDir() {
        return dir.exists();
    }

    private static boolean createDir() {
        dir.mkdirs();
        return true;
    }
}

