/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.compatibility.quests;

import com.gmail.berndivader.mythicmobsext.compatibility.quests.QuestsSupport;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import me.blackvein.quests.Quest;
import me.blackvein.quests.Quester;
import me.blackvein.quests.Quests;
import org.bukkit.entity.Player;

public class QuestsMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    Quests quests = QuestsSupport.inst().quests();
    String s1;
    String s2;
    int i1;

    public QuestsMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.s1 = mlc.getString("quest", "").toLowerCase();
        this.i1 = mlc.getInteger("stage", 0);
        if (!this.s1.isEmpty() && this.s1.charAt(0) == '\"') {
            this.s1 = SkillString.parseMessageSpecialChars((String)this.s1.substring(1, this.s1.length() - 1));
        }
        this.s2 = skill.toUpperCase().split("QUEST\\{")[0];
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity e) {
        Player p;
        Quester q;
        if (e.isPlayer() && (q = this.quests.getQuester((p = (Player)e.getBukkitEntity()).getUniqueId())) != null) {
            Quest quest = QuestsSupport.getQuestFromCurrent(q, this.s1);
            switch (this.s2) {
                case "COMPLETEQUEST": {
                    if (quest == null) break;
                    quest.completeQuest(q);
                    break;
                }
                case "TAKEQUEST": {
                    if (quest != null || (quest = this.quests.getQuest(this.s1)) == null) break;
                    q.takeQuest(quest, true);
                    break;
                }
                case "FAILQUEST": {
                    if (quest == null) break;
                    quest.failQuest(q);
                    break;
                }
                case "NEXTSTAGEQUEST": {
                    if (quest == null) break;
                    quest.nextStage(q, false);
                    quest.updateCompass(q, q.getCurrentStage(quest));
                    break;
                }
                case "SETSTAGEQUEST": {
                    if (quest == null) break;
                    quest.setStage(q, this.i1);
                    quest.updateCompass(q, q.getCurrentStage(quest));
                }
            }
        }
        return true;
    }
}

