/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.mechanics.AuraMechanic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="curse", author="BerndiVader")
public class Curse
extends AuraMechanic
implements ITargetedEntitySkill {
    int duration;
    float ratio;
    boolean infinite;
    boolean strict;
    boolean cancel = false;
    List<EntityRegainHealthEvent.RegainReason> reasons;
    Optional<Skill> matchSkill = Optional.empty();
    Optional<Skill> startSkill = Optional.empty();
    Optional<Skill> failSkill = Optional.empty();
    Optional<Skill> endSkill = Optional.empty();
    static final String str = "MME_CURSE";

    public Curse(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String temp;
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.auraName = Optional.of(str);
        this.reasons = new ArrayList<EntityRegainHealthEvent.RegainReason>();
        this.ratio = mlc.getFloat("ratio", 1.0f);
        this.strict = mlc.getBoolean("strict", false);
        if (this.strict && !(this.strict = (temp = mlc.getString("reasons", "eating,regen,satiated,magic,magic_regen").toUpperCase()).contains("ANY"))) {
            String[] parse = temp.split(",");
            int size = parse.length;
            for (int i1 = 0; i1 < size; ++i1) {
                try {
                    EntityRegainHealthEvent.RegainReason rr = EntityRegainHealthEvent.RegainReason.valueOf((String)parse[i1]);
                    this.reasons.add(rr);
                    continue;
                }
                catch (Exception ex) {
                    Main.logger.warning("There was no valid reason for " + parse[i1] + ". Ignoring it.");
                }
            }
        }
        this.infinite = mlc.getBoolean("infinite", false);
        this.duration = mlc.getInteger("period", 120);
        String s1 = mlc.getString("matchskill");
        if (s1 != null) {
            this.matchSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("startskill")) != null) {
            this.startSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("endskill")) != null) {
            this.endSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("failskill")) != null) {
            this.failSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstractEntity) {
        if (!abstractEntity.getBukkitEntity().hasMetadata(str)) {
            new CurseTracker(this, data, abstractEntity);
            return true;
        }
        return false;
    }

    class CurseTracker
    extends Aura.AuraTracker
    implements Runnable,
    IParentSkill,
    Listener {
        final Curse buff;
        final float ratio;
        final int uid;
        int ticksRemaining;
        boolean hasEnded;
        AbstractEntity abstractEntity;
        double prevHealth;
        EntityRegainHealthEvent.RegainReason currentReason;

        public CurseTracker(Curse buff, SkillMetadata data, AbstractEntity abstractEntity) {
            SkillMetadata sd;
            Skill sk;
            super((Aura)Curse.this, abstractEntity, data);
            this.ratio = Curse.this.ratio;
            this.hasEnded = false;
            this.currentReason = null;
            this.uid = abstractEntity.getBukkitEntity().getEntityId();
            this.buff = buff;
            this.ticksRemaining = buff.duration;
            this.skillMetadata.setCallingEvent((IParentSkill)this);
            this.abstractEntity = abstractEntity;
            if (Curse.this.strict) {
                Main.pluginmanager.registerEvents((Listener)this, (Plugin)Main.getPlugin());
            }
            if (Curse.this.startSkill.isPresent() && (sk = Curse.this.startSkill.get()).isUsable(sd = data.deepClone())) {
                sk.execute(sd);
            }
            this.prevHealth = abstractEntity.getHealth();
            this.start();
        }

        @Override
        public void run() {
            if (!this.buff.infinite) {
                --this.ticksRemaining;
            }
            if (this.abstractEntity == null || this.abstractEntity.isDead() || !this.hasEnded && this.ticksRemaining <= 0) {
                if (Curse.this.endSkill.isPresent() && Curse.this.endSkill.get().isUsable(this.skillMetadata)) {
                    Curse.this.endSkill.get().execute(this.skillMetadata.deepClone());
                }
                this.terminate();
            } else {
                double health = this.abstractEntity.getHealth();
                if (this.prevHealth < health) {
                    double amount = (health - this.prevHealth) * (double)this.ratio;
                    if (Curse.this.strict) {
                        SkillMetadata sd;
                        Skill sk;
                        if (this.currentReason != null && Curse.this.reasons.contains(this.currentReason)) {
                            this.doMatchSkill(health, amount);
                            this.currentReason = null;
                        } else if (Curse.this.failSkill.isPresent() && (sk = Curse.this.failSkill.get()).isUsable(sd = this.skillMetadata.deepClone())) {
                            sk.execute(sd);
                        }
                    } else {
                        this.doMatchSkill(health, amount);
                    }
                }
                this.prevHealth = this.abstractEntity.getHealth();
            }
        }

        void doMatchSkill(double health, double amount) {
            if (Curse.this.matchSkill.isPresent()) {
                SkillMetadata sd;
                Skill sk = Curse.this.matchSkill.get();
                if (sk.isUsable(sd = this.skillMetadata.deepClone())) {
                    sk.execute(sd);
                    this.abstractEntity.setHealth(health - amount);
                }
            } else {
                this.abstractEntity.setHealth(health - amount);
            }
        }

        @EventHandler
        public void onRegainHealth(EntityRegainHealthEvent e) {
            if (e.getEntity().getEntityId() == this.uid) {
                this.currentReason = e.getRegainReason();
            }
        }

        public boolean getCancelled() {
            return this.hasTerminated();
        }

        public void setCancelled() {
            this.terminate();
        }

        public boolean terminate() {
            SkillMetadata sd;
            Skill sk;
            HandlerList.unregisterAll((Listener)this);
            if (!this.hasEnded) {
                if (Curse.this.auraName.isPresent()) {
                    this.skillMetadata.getCaster().unregisterAura((String)Curse.this.auraName.get(), (Aura.AuraTracker)this);
                }
                this.hasEnded = true;
            }
            this.abstractEntity.getBukkitEntity().removeMetadata(Curse.str, (Plugin)Main.getPlugin());
            if (Curse.this.endSkill.isPresent() && (sk = Curse.this.endSkill.get()).isUsable(sd = this.skillMetadata.deepClone())) {
                sk.execute(sd);
            }
            this.close();
            return true;
        }
    }
}

