/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.targeters.CustomTargeters;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitPlayer;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.skills.targeters.ConsoleTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.CustomTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.skills.targeters.OriginTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.TargetLocationTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.TriggerTargeter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@ExternalAnnotation(name="customteleport", author="BerndiVader")
public class CustomTeleportMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    PlaceholderString stargeter;
    String FinalSignal;
    String inBetweenLastSignal;
    String inBetweenNextSignal;
    String[] stricts;
    String[] excludes;
    boolean inFrontOf;
    boolean isLocations;
    boolean returnToStart;
    boolean sortTargets;
    boolean targetInsight;
    boolean ignoreOwner;
    boolean ignorePitch;
    double delay;
    double noise;
    double maxTargets;
    double frontOffset;
    double sideOffset;
    double yOffset;

    public CustomTeleportMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        double d;
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.noise = mlc.getDouble(new String[]{"noise", "n", "radius", "r"}, 0.0);
        this.delay = mlc.getDouble(new String[]{"teleportdelay", "tdelay", "td"}, 0.0);
        this.frontOffset = mlc.getDouble(new String[]{"frontoffest", "fo"}, 0.0);
        this.sideOffset = mlc.getDouble(new String[]{"sideoffset", "so"}, 0.0);
        this.yOffset = mlc.getDouble(new String[]{"yoffset", "yo"}, 0.0);
        this.maxTargets = mlc.getDouble(new String[]{"maxtargets", "mt"}, 0.0);
        if (d < 0.0) {
            this.maxTargets = 0.0;
        }
        this.inFrontOf = mlc.getBoolean(new String[]{"infrontof", "infront", "front", "f"}, false);
        this.returnToStart = mlc.getBoolean(new String[]{"returntostart", "return", "rs"}, false);
        this.targetInsight = mlc.getBoolean(new String[]{"targetinsight", "insight", "is"}, false);
        this.ignoreOwner = mlc.getBoolean(new String[]{"ignoreowner", "io"}, false);
        this.ignorePitch = mlc.getBoolean(new String[]{"ignorepitch", "ip"}, false);
        this.inBetweenLastSignal = mlc.getString(new String[]{"betweenlastentitysignal", "bls"}, null, new String[0]);
        this.inBetweenNextSignal = mlc.getString(new String[]{"betweennextentitysignal", "bns"}, null, new String[0]);
        this.FinalSignal = mlc.getString(new String[]{"finalsignal", "final", "fs"}, null, new String[0]);
        this.excludes = mlc.getString("exclude", "").split(",");
        this.stricts = mlc.getString("stricts", "").split(",");
        String s = mlc.getString(new String[]{"destination", "dest", "d", "location", "loc", "l"}, "@self", new String[0]);
        s = s.replaceAll("<&lc>", "{");
        s = s.replaceAll("<&rc>", "}");
        s = s.replaceAll("<&eq>", "=");
        s = s.replaceAll("<&sc>", ";");
        s = s.replaceAll("<&cm>", ",");
        s = s.replaceAll("<&lb>", "[");
        s = s.replaceAll("<&rb>", "]");
        String parse = s = s.substring(1, s.length() - 1);
        if (!parse.startsWith("@")) {
            parse = "@" + parse;
        }
        this.stargeter = new PlaceholderString(parse);
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        return this.doMechanic(data, target);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.doMechanic(data, target);
    }

    private boolean doMechanic(final SkillMetadata data, final Object target) {
        String targeter = this.stargeter.get((PlaceholderMeta)data);
        if (!target.getClass().equals(BukkitEntity.class) && !target.getClass().equals(BukkitPlayer.class)) {
            Bukkit.getLogger().warning("A location is not a valid source for advanced teleport mechanic!");
            return false;
        }
        targeter = this.stargeter.get((PlaceholderMeta)data, (AbstractEntity)target);
        final AbstractEntity entityTarget = (AbstractEntity)target;
        final AbstractLocation startLocation = ((AbstractEntity)target).getLocation();
        final HashSet osources = (HashSet)CustomTeleportMechanic.getDestination(targeter, data);
        if (osources == null || !osources.iterator().hasNext()) {
            return false;
        }
        this.isLocations = osources.iterator().next() instanceof AbstractLocation;
        if (this.maxTargets > 0.0 && (double)osources.size() > this.maxTargets) {
            HashSet lsrc = new HashSet();
            Iterator it = osources.iterator();
            int c = 1;
            while (it.hasNext()) {
                if ((double)c > this.maxTargets) {
                    osources.clear();
                    osources.addAll(lsrc);
                    break;
                }
                lsrc.add(it.next());
                ++c;
            }
        }
        if (!this.isLocations && this.ignoreOwner && data.getCaster() instanceof ActiveMob && ((ActiveMob)data.getCaster()).getOwner().isPresent()) {
            World w = data.getCaster().getEntity().getBukkitEntity().getWorld();
            osources.remove(BukkitAdapter.adapt((Entity)NMSUtils.getEntity(w, (UUID)((ActiveMob)data.getCaster()).getOwner().get())));
        }
        new BukkitRunnable(){
            AbstractEntity sourceEntity;
            AbstractEntity lastEntity;
            boolean isLoc;
            boolean ifo;
            boolean is;
            Iterator<?> it;
            double n;
            double fo;
            double so;
            double yo;
            boolean ip;
            String bls;
            String bns;
            String fs;
            AbstractLocation start;
            {
                this.sourceEntity = entityTarget;
                this.isLoc = CustomTeleportMechanic.this.isLocations;
                this.ifo = CustomTeleportMechanic.this.inFrontOf;
                this.is = CustomTeleportMechanic.this.targetInsight;
                this.it = osources.iterator();
                this.n = CustomTeleportMechanic.this.noise;
                this.fo = CustomTeleportMechanic.this.frontOffset;
                this.so = CustomTeleportMechanic.this.sideOffset;
                this.yo = CustomTeleportMechanic.this.yOffset;
                this.ip = CustomTeleportMechanic.this.ignorePitch;
                this.bls = CustomTeleportMechanic.this.inBetweenLastSignal;
                this.bns = CustomTeleportMechanic.this.inBetweenNextSignal;
                this.fs = CustomTeleportMechanic.this.FinalSignal;
                this.start = startLocation;
            }

            public void run() {
                if (!this.it.hasNext()) {
                    if (CustomTeleportMechanic.this.returnToStart) {
                        this.sourceEntity.teleport(this.start);
                    }
                    if (this.fs != null) {
                        if (this.isLoc) {
                            ((ActiveMob)data.getCaster()).signalMob(null, this.fs);
                        } else {
                            ((ActiveMob)data.getCaster()).signalMob((AbstractEntity)target, this.fs);
                        }
                    }
                    this.cancel();
                    return;
                }
                Object target2 = this.it.next();
                if (this.isLoc) {
                    if (this.n > 0.0) {
                        target2 = MobManager.findSafeSpawnLocation((AbstractLocation)((AbstractLocation)target2), (int)((int)this.n), (int)0, (int)((ActiveMob)data.getCaster()).getType().getMythicEntity().getHeight(), (boolean)false);
                    }
                    Location ll = BukkitAdapter.adapt((AbstractLocation)((AbstractLocation)target2));
                    if (this.bns != null) {
                        ((ActiveMob)data.getCaster()).signalMob(null, this.bns);
                    }
                    if (this.ip) {
                        ll.setPitch(0.0f);
                    }
                    if (this.fo != 0.0 || this.so != 0.0) {
                        Vector foV = MathUtils.getFrontBackOffsetVector(ll.getDirection(), this.fo);
                        Vector soV = MathUtils.getSideOffsetVectorFixed(ll.getYaw(), this.so, false);
                        ll.add(foV);
                        ll.add(soV);
                    }
                    target2 = BukkitAdapter.adapt((Location)ll);
                    this.sourceEntity.teleport(((AbstractLocation)target2).add(0.0, this.yo, 0.0));
                    if (this.bls != null) {
                        ((ActiveMob)data.getCaster()).signalMob(null, this.bls);
                    }
                } else {
                    if (this.lastEntity == null) {
                        this.lastEntity = this.sourceEntity;
                    }
                    AbstractEntity t = (AbstractEntity)target2;
                    target2 = ((AbstractEntity)target2).getLocation();
                    if (!this.is || this.sourceEntity.hasLineOfSight(t)) {
                        if (this.ifo) {
                            target2 = t.getLocation().add(t.getLocation().getDirection().setY(0).normalize().multiply(2));
                        }
                        if (this.n > 0.0) {
                            target2 = MobManager.findSafeSpawnLocation((AbstractLocation)((AbstractLocation)target2), (int)((int)this.n), (int)0, (int)((int)BukkitAdapter.adapt((AbstractEntity)data.getCaster().getEntity()).getHeight()), (boolean)false);
                        }
                        if (this.bns != null) {
                            ((ActiveMob)data.getCaster()).signalMob(t, this.bns);
                        }
                        Location ll = BukkitAdapter.adapt((AbstractLocation)((AbstractLocation)target2));
                        if (this.ip) {
                            ll.setPitch(0.0f);
                        }
                        if (this.fo != 0.0 || this.so != 0.0) {
                            Vector foV = MathUtils.getFrontBackOffsetVector(ll.getDirection(), this.fo);
                            Vector soV = MathUtils.getSideOffsetVectorFixed(ll.getYaw(), this.so, false);
                            ll.add(foV);
                            ll.add(soV);
                        }
                        target2 = BukkitAdapter.adapt((Location)ll);
                        this.sourceEntity.teleport(((AbstractLocation)target2).add(0.0, this.yo, 0.0));
                        if (this.bls != null) {
                            ((ActiveMob)data.getCaster()).signalMob(this.lastEntity, this.bls);
                        }
                        this.lastEntity = t;
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)this.delay);
        return true;
    }

    protected static Collection<?> getDestination(String target, SkillMetadata skilldata) {
        SkillMetadata data = new SkillMetadata(SkillTrigger.API, skilldata.getCaster(), skilldata.getTrigger(), skilldata.getOrigin(), null, null, 1.0f);
        Optional<SkillTargeter> maybeTargeter = Optional.of(Utils.parseSkillTargeter(target));
        if (maybeTargeter.isPresent()) {
            SkillTargeter targeter = maybeTargeter.get();
            if (targeter instanceof CustomTargeter) {
                String s1 = target.substring(1);
                MythicLineConfig mlc = new MythicLineConfig(s1);
                String s2 = s1.contains("{") ? s1.substring(0, s1.indexOf("{")) : s1;
                targeter = CustomTargeters.getCustomTargeter(s2, mlc);
                if (targeter == null) {
                    targeter = new TriggerTargeter(mlc);
                }
            }
            if (targeter instanceof IEntitySelector) {
                data.setEntityTargets((Collection)((IEntitySelector)targeter).getEntities(data));
                ((IEntitySelector)targeter).filter(data, false);
                return data.getEntityTargets();
            }
            if (targeter instanceof ILocationSelector) {
                data.setLocationTargets((Collection)((ILocationSelector)targeter).getLocations(data));
                ((ILocationSelector)targeter).filter(data);
            } else if (targeter instanceof OriginTargeter) {
                data.setLocationTargets((Collection)((OriginTargeter)targeter).getLocation(data.getOrigin()));
            } else if (targeter instanceof TargetLocationTargeter) {
                HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
                lTargets.add(data.getTrigger().getLocation());
                data.setLocationTargets(lTargets);
            }
            if (targeter instanceof ConsoleTargeter) {
                data.setEntityTargets(null);
                data.setLocationTargets(null);
            }
            return data.getLocationTargets();
        }
        return null;
    }
}

