/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.utils;

import com.gmail.berndivader.mythicmobsext.Main;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class UndoBlockListener
implements Listener {
    private static Collection<Material> dList = new ArrayList<Material>(Arrays.asList(Material.CHEST, Material.TRAPPED_CHEST, Material.ENDER_CHEST, Material.ANVIL, Material.DISPENSER, Material.BREWING_STAND, Material.FURNACE));

    public static Double getRandomVel(Double min, Double max) {
        return Main.random.nextDouble() * (max - min) + min;
    }

    @EventHandler
    public void removeFallingBlock(EntityChangeBlockEvent e) {
        if (!e.getEntity().hasMetadata("removeit")) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void GrenadeBlockDestroy(EntityExplodeEvent e) {
        if (e.getEntityType() == EntityType.PRIMED_TNT && !e.isCancelled() && !e.blockList().isEmpty()) {
            Entity e1 = e.getEntity();
            if (!e1.hasMetadata("customgrenade")) {
                return;
            }
            if (e1.hasMetadata("noblkdmg") && !((MetadataValue)e1.getMetadata("noblkdmg").get(0)).asBoolean()) {
                e.setCancelled(true);
                e.getLocation().getWorld().createExplosion(e.getLocation().getX(), e.getLocation().getY(), e.getLocation().getZ(), 2.0f, false, false);
                return;
            }
            if (e1.hasMetadata("undotnt") && !((MetadataValue)e1.getMetadata("undotnt").get(0)).asBoolean()) {
                return;
            }
            final boolean ueffect = e1.hasMetadata("ueffect") ? ((MetadataValue)e1.getMetadata("ueffect").get(0)).asBoolean() : false;
            int utime = e1.hasMetadata("utime") ? ((MetadataValue)e1.getMetadata("utime").get(0)).asInt() : 0;
            e.setYield(0.0f);
            final ArrayList<BlockState> blocks = new ArrayList<BlockState>();
            ListIterator lblocks = e.blockList().listIterator();
            while (lblocks.hasNext()) {
                Block b = (Block)lblocks.next();
                if (dList.contains(b.getType())) {
                    lblocks.remove();
                    continue;
                }
                b.getDrops().clear();
                if (b.getType() == Material.AIR || blocks.contains(b.getState())) continue;
                blocks.add(b.getState());
                FallingBlock fb = b.getWorld().spawnFallingBlock(b.getLocation(), Material.FIRE, (byte)0);
                fb.setVelocity(new Vector(UndoBlockListener.getRandomVel(-0.5, 0.5).doubleValue(), UndoBlockListener.getRandomVel(0.1, 0.5).doubleValue(), UndoBlockListener.getRandomVel(-0.5, 0.5).doubleValue()));
                fb.setMetadata("removeit", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)true));
            }
            Collections.shuffle(blocks);
            new BukkitRunnable(){
                int i = 0;

                public void run() {
                    if (this.i < blocks.size()) {
                        BlockState bs = (BlockState)blocks.get(this.i);
                        bs.getBlock().setType(bs.getType());
                        bs.update();
                        if (ueffect) {
                            bs.getBlock().getWorld().playEffect(bs.getLocation(), Effect.STEP_SOUND, (Object)bs.getBlock().getType());
                        }
                    } else {
                        blocks.clear();
                        this.cancel();
                    }
                    ++this.i;
                }
            }.runTaskTimer((Plugin)Main.getPlugin(), (long)utime, 1L);
        }
    }
}

