/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.RangedDouble;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@ExternalAnnotation(name="entitiesinradius,eir,leir,livingentitiesinradius,pir,playersinradius", author="BerndiVader")
public class EntitiesInRadiusCondition
extends AbstractCustomCondition
implements ILocationCondition {
    private RangedDouble a;
    private double r;
    private boolean all = false;
    private boolean is;
    private boolean ignoreNPC;
    private char c;
    private List<String> mList = new ArrayList<String>();

    public EntitiesInRadiusCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.c = line.toUpperCase().charAt(0);
        String[] t = mlc.getString(new String[]{"entities", "entity", "types", "type", "t", "e"}, "ALL", new String[0]).toUpperCase().split(",");
        if (t[0].toUpperCase().equals("ALL") || this.c == 'P') {
            this.all = true;
        }
        this.a = new RangedDouble(mlc.getString(new String[]{"amount", "a"}, ">0", new String[0]), false);
        this.r = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
        this.is = mlc.getBoolean(new String[]{"ignoresameblock", "isb"}, false);
        this.ignoreNPC = mlc.getBoolean(new String[]{"ignorenpc", "npc"}, false);
        this.mList = Arrays.asList(t);
    }

    public boolean check(AbstractLocation location) {
        Class<LivingEntity> clazz;
        switch (this.c) {
            case 'L': {
                clazz = LivingEntity.class;
                break;
            }
            case 'P': {
                clazz = Player.class;
                break;
            }
            default: {
                clazz = Entity.class;
            }
        }
        return this.checkEntity(location, clazz);
    }

    private boolean checkEntity(AbstractLocation location, Class<?> clazz) {
        int count = 0;
        Location l = BukkitAdapter.adapt((AbstractLocation)location);
        for (Entity e : l.getWorld().getEntitiesByClasses(new Class[]{clazz})) {
            double diffsq;
            if (!this.all && !this.mList.contains(e.getType().toString().toUpperCase()) || this.ignoreNPC && e.hasMetadata("NPC")) continue;
            Location el = e.getLocation();
            if (l.getWorld() != el.getWorld() || this.is && Utils.cmpLocByBlock(el, l) || !((diffsq = l.distanceSquared(el)) <= Math.pow(this.r, 2.0))) continue;
            ++count;
        }
        return this.a.equals(count);
    }
}

