/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.healthbar;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.healthbar.ChangeHealthbar;
import com.gmail.berndivader.mythicmobsext.healthbar.CreateHealthbar;
import com.gmail.berndivader.mythicmobsext.healthbar.Healthbar;
import com.gmail.berndivader.mythicmobsext.healthbar.LineSpeechBubbleMechanic;
import com.gmail.berndivader.mythicmobsext.healthbar.ModifySpeechBubbleMechanic;
import com.gmail.berndivader.mythicmobsext.healthbar.RemoveSpeechBubbleMechanic;
import com.gmail.berndivader.mythicmobsext.healthbar.SpeechBubble;
import com.gmail.berndivader.mythicmobsext.healthbar.SpeechBubbleMechanic;
import com.gmail.berndivader.mythicmobsext.healthbar.UpdateHealthbar;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class HealthbarHandler
implements Listener {
    static Plugin plugin = Main.getPlugin();
    static Logger logger = Main.logger;
    static String str_pluginName;
    public static ConcurrentHashMap<UUID, Healthbar> healthbars;
    public static ConcurrentHashMap<String, SpeechBubble> speechbubbles;
    HealthbarClock clock = new HealthbarClock();

    public HealthbarHandler(Plugin plugin) {
        Main.pluginmanager.registerEvents((Listener)this, plugin);
    }

    public ConcurrentHashMap<UUID, Healthbar> getHealthbars() {
        return healthbars;
    }

    public void removeHealthbars() {
        healthbars.forEach((uuid, healthbar) -> healthbar.remove());
    }

    public void removeSpeechBubbles() {
        speechbubbles.forEach((uuid, bubbles) -> bubbles.remove());
    }

    @EventHandler
    public void registerMythicMobsMechanics(MythicMechanicLoadEvent e) {
        String mechanic;
        switch (mechanic = e.getMechanicName().toLowerCase()) {
            case "createhealthbar": 
            case "createhealthbar_ext": {
                CreateHealthbar skill = new CreateHealthbar(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "changehealthbar": 
            case "changehealthbar_ext": {
                ChangeHealthbar skill = new ChangeHealthbar(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "updatehealthbar": 
            case "updatehealthbar_ext": {
                UpdateHealthbar skill = new UpdateHealthbar(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "speechbubble": 
            case "speechbubble_ext": {
                SpeechBubbleMechanic skill = new SpeechBubbleMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "removebubble": 
            case "removebubble_ext": {
                RemoveSpeechBubbleMechanic skill = new RemoveSpeechBubbleMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "modifybubble": 
            case "modifybubble_ext": {
                ModifySpeechBubbleMechanic skill = new ModifySpeechBubbleMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
                break;
            }
            case "linebubble": 
            case "linebubble_ext": {
                LineSpeechBubbleMechanic skill = new LineSpeechBubbleMechanic(e.getContainer().getConfigLine(), e.getConfig());
                e.register((SkillMechanic)skill);
            }
        }
    }

    @EventHandler
    public void updateHealthbar(final EntityDamageEvent e) {
        new BukkitRunnable(){

            public void run() {
                UUID uuid;
                Healthbar h;
                if (healthbars.containsKey(e.getEntity().getUniqueId()) && (h = healthbars.get(uuid = e.getEntity().getUniqueId())) != null) {
                    h.updateHealth();
                }
            }
        }.runTaskLater(plugin, 1L);
    }

    static {
        plugin = Main.getPlugin();
        logger = Main.logger;
        str_pluginName = "HolograpicDisplays";
        healthbars = new ConcurrentHashMap();
        speechbubbles = new ConcurrentHashMap();
        logger.info("using " + str_pluginName);
    }

    public class HealthbarClock
    implements Runnable {
        protected BukkitTask taskId = Bukkit.getScheduler().runTaskTimer(plugin, () -> this.run(), 0L, 1L);

        @Override
        public void run() {
            healthbars.forEach((uuid, healthbar) -> {
                LivingEntity e = healthbar.entity;
                if (e == null || e.isDead()) {
                    healthbar.remove();
                } else {
                    healthbar.update();
                }
            });
            speechbubbles.forEach((idx, bubble) -> {
                LivingEntity e = bubble.entity;
                if (e == null || e.isDead()) {
                    bubble.remove();
                } else {
                    bubble.update();
                }
            });
        }
    }
}

