/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageEvent;

@ExternalAnnotation(name="customdamage", author="BerndiVader")
public class CustomDamageMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    boolean pk;
    boolean pi;
    boolean ia;
    boolean iabs;
    boolean ip;
    boolean p;
    boolean uc;
    boolean pcur;
    boolean ploss;
    boolean debug;
    boolean rdbd;
    boolean ncp;
    boolean strict;
    double dbd;
    EntityDamageEvent.DamageCause cause;
    PlaceholderString amount;
    String ca;
    List<EntityType> pi_ignores;

    public CustomDamageMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        double d;
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.pk = mlc.getBoolean(new String[]{"preventknockback", "pkb", "pk"}, false);
        String value = mlc.getString(new String[]{"amount", "a"}, "1", new String[0]);
        if (value.startsWith("-")) {
            value = "1";
        }
        this.amount = new PlaceholderString(value);
        this.ia = mlc.getBoolean(new String[]{"ignorearmor", "ignorearmour", "ia", "i"}, false);
        this.pi = mlc.getBoolean(new String[]{"preventimmunity", "pi"}, false);
        this.iabs = mlc.getBoolean(new String[]{"ignoreabsorbtion", "ignoreabs", "iabs"}, false);
        this.ip = mlc.getBoolean(new String[]{"ignorepower", "ip"}, false);
        this.p = mlc.getBoolean(new String[]{"percentage", "p"}, false);
        this.uc = mlc.getBoolean(new String[]{"usecaster", "uc"}, false);
        this.strict = mlc.getBoolean("strict", false);
        this.pcur = mlc.getBoolean(new String[]{"percentcurrent", "pcur", "pc"}, false);
        this.ploss = mlc.getBoolean(new String[]{"percentloss", "ploss", "pl"}, false);
        if (this.ploss) {
            this.pcur = false;
        }
        String[] ignores = mlc.getString("ignores", "").toUpperCase().split(",");
        this.ca = mlc.getString(new String[]{"damagecause", "cause", "dc"}, "CUSTOM", new String[0]).toUpperCase();
        this.dbd = -mlc.getDouble(new String[]{"reducedamagebydistance", "rdbd", "damagebydistance", "dbd"}, 0.0);
        this.dbd = mlc.getDouble(new String[]{"increasedamagebydistance", "idbd"}, this.dbd);
        this.rdbd = d < 0.0;
        this.dbd = Math.abs(this.dbd);
        this.cause = EntityDamageEvent.DamageCause.CUSTOM;
        for (EntityDamageEvent.DamageCause dc : EntityDamageEvent.DamageCause.values()) {
            if (!dc.toString().equals(this.ca)) continue;
            this.cause = dc;
            break;
        }
        this.pi_ignores = new ArrayList<EntityType>();
        for (int i1 = 0; i1 < ignores.length; ++i1) {
            for (EntityType type : EntityType.values()) {
                String parse = ignores[i1];
                if (!type.toString().equals(parse)) continue;
                this.pi_ignores.add(EntityType.valueOf((String)parse));
            }
        }
        this.ncp = mlc.getBoolean("ncp", false);
        this.debug = mlc.getBoolean("debug", false);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity t) {
        if (!t.isValid() || t.isDead() || t.getHealth() <= 0.0 || data.getCaster().isUsingDamageSkill()) {
            return false;
        }
        AbstractEntity c = data.getCaster().getEntity();
        double dmg = MathUtils.randomRangeDouble(this.amount.get((PlaceholderMeta)data, t));
        if (this.p) {
            double d = this.pcur ? (this.uc ? c.getHealth() * dmg : t.getHealth() * dmg) : (this.ploss ? (this.uc ? (c.getMaxHealth() - c.getHealth()) * dmg : (t.getMaxHealth() - t.getHealth()) * dmg) : (dmg = this.uc ? c.getMaxHealth() * dmg : t.getMaxHealth() * dmg));
        }
        if (!this.ip) {
            dmg *= (double)data.getPower();
        }
        if (this.dbd > 0.0) {
            int dd = (int)Math.sqrt(MathUtils.distance3D(data.getCaster().getEntity().getBukkitEntity().getLocation().toVector(), t.getBukkitEntity().getLocation().toVector()));
            dmg = this.rdbd ? dmg - dmg * ((double)dd * this.dbd) : dmg + dmg * ((double)dd * this.dbd);
        }
        Utils.doDamage(data.getCaster(), t, dmg, this.ia, this.pk, this.pi, this.pi_ignores, this.iabs, this.debug, this.cause, this.ncp, this.strict);
        return true;
    }
}

