/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import io.netty.handler.codec.DecoderResult;
import java.util.Map;
import java.util.function.Function;
import reactor.netty.http.logging.AbstractHttpMessageLogFactory;
import reactor.netty.http.logging.HttpMessageArgProvider;
import reactor.netty.http.logging.HttpMessageLogUtils;

public class ReactorNettyHttpMessageLogFactory
extends AbstractHttpMessageLogFactory {
    public static final ReactorNettyHttpMessageLogFactory INSTANCE = new ReactorNettyHttpMessageLogFactory();
    static final Function<String, String> DEFAULT_URI_VALUE_FUNCTION = s2 -> {
        int index = s2.indexOf(63);
        return index == -1 ? s2 : s2.substring(0, index + 1) + "<filtered>";
    };
    static final Function<DecoderResult, String> DEFAULT_DECODER_RESULT_FUNCTION = decoderResult -> {
        if (decoderResult.isFinished()) {
            if (decoderResult.isSuccess()) {
                return "success";
            }
            String cause = decoderResult.cause().toString();
            return new StringBuilder(cause.length() + 17).append("failure(").append(cause).append(')').toString();
        }
        return "unfinished";
    };
    static final Function<Map.Entry<String, String>, String> DEFAULT_HEADER_VALUE_FUNCTION = e -> "<filtered>";

    @Override
    public String common(HttpMessageArgProvider arg) {
        return HttpMessageLogUtils.logHttpMessage(arg, this.uriValueFunction(), this.decoderResultFunction(), this.headerValueFunction());
    }

    protected Function<String, String> uriValueFunction() {
        return DEFAULT_URI_VALUE_FUNCTION;
    }

    protected Function<DecoderResult, String> decoderResultFunction() {
        return DEFAULT_DECODER_RESULT_FUNCTION;
    }

    protected Function<Map.Entry<String, String>, String> headerValueFunction() {
        return DEFAULT_HEADER_VALUE_FUNCTION;
    }
}

