/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.websocket;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.mysql.MakeDownloadable;
import com.gmail.berndivader.streamserver.term.ANSI;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@ServerEndpoint(value="/dl")
public class EndPoint {
    private Session session;
    private boolean flowRunning = false;

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        ANSI.info("WS-CLIENT connected.");
        ANSI.prompt();
        Helper.EXECUTOR.submit(new PingRunner());
    }

    @OnMessage
    public void onMessage(String content) throws IOException {
        if (this.flowRunning) {
            return;
        }
        if (Helper.isUrl(content)) {
            this.flowRunning = true;
            this.session.getBasicRemote().sendText(STATUS.ACCEPT.value);
            this.download(content);
        }
        this.session.close();
    }

    @OnError
    public void onError(Throwable throwable) throws IOException {
        ANSI.error("WebSocket created an error: ", throwable);
        ANSI.prompt();
        this.session.close(new CloseReason(CloseReason.CloseCodes.PROTOCOL_ERROR, "WebSocket Error."));
    }

    @OnClose
    public void onClose(CloseReason reson) {
        ANSI.info("WS-CLIENT connection closed. Code: " + reson.getCloseCode().getCode() + ", Reason: " + reson.getReasonPhrase());
        ANSI.prompt();
    }

    private void download(String content) throws IOException {
        block24: {
            try {
                File file;
                Map.Entry<ProcessBuilder, InfoPacket> entry = EndPoint.getDownloader(content);
                ProcessBuilder builder = entry.getKey();
                InfoPacket info = entry.getValue();
                if (info.isSet(info.error)) {
                    this.session.getBasicRemote().sendText(STATUS.ERROR.value + info.error);
                    break block24;
                }
                Process process = builder.start();
                try (InputStream input = process.getInputStream();
                     BufferedReader error = process.errorReader();){
                    long time = System.currentTimeMillis();
                    while (process.isAlive()) {
                        if (this.session == null || !this.session.isOpen()) {
                            ANSI.raw("[BR]");
                            ANSI.raw("Download process terminated because it appears, ws-client is gone.");
                            process.destroy();
                            continue;
                        }
                        int avail = input.available();
                        if (avail > 0) {
                            String[] temp;
                            time = System.currentTimeMillis();
                            String line2 = new String(input.readNBytes(avail));
                            if (line2.contains("[Metadata]") && (temp = line2.split("\"")).length > 0) {
                                info.local_filename = temp[1];
                            }
                            this.session.getAsyncRemote().sendText(STATUS.INFO.value + line2);
                        }
                        if (System.currentTimeMillis() - time <= Config.DL_TIMEOUT_SECONDS * 1000L) continue;
                        ANSI.raw("[BR]");
                        ANSI.raw("Download process terminated because it appears, process is stalled since " + Config.DL_TIMEOUT_SECONDS / 60L + " minutes.");
                        process.destroy();
                    }
                    if (error != null && error.ready()) {
                        ANSI.raw("[BR]");
                        error.lines().forEach(line -> ANSI.warn(line));
                    }
                }
                if (process.isAlive()) {
                    process.destroy();
                }
                ANSI.raw("[BR]");
                if (info.downloadable.booleanValue() && Config.DATABASE_USE.booleanValue() && (file = new File(builder.directory().getAbsolutePath() + "/" + info.local_filename)).exists() && file.isFile() && file.canRead()) {
                    MakeDownloadable downloadable = new MakeDownloadable(file, info.temp);
                    Optional<String> optLink = downloadable.future.get(2L, TimeUnit.MINUTES);
                    optLink.ifPresentOrElse(link -> {
                        if (this.session != null && this.session.isOpen()) {
                            this.session.getAsyncRemote().sendText(STATUS.READY.value + link);
                        }
                    }, () -> {
                        if (this.session != null && this.session.isOpen()) {
                            this.session.getAsyncRemote().sendText(STATUS.ERROR.value + "Failed to create downloadable file.");
                        }
                    });
                }
            }
            catch (Exception e) {
                if (this.session != null && this.session.isOpen()) {
                    this.session.getBasicRemote().sendText(STATUS.ERROR.value + "Download failed.");
                }
                ANSI.raw("[BR]");
                ANSI.error("Error while looping yt-dlp process.", e);
            }
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    private static Map.Entry<ProcessBuilder, InfoPacket> getDownloader(String url) {
        Optional<File> opt = Helper.getOrCreateMediaDir(Config.DL_ROOT_PATH);
        if (opt.isEmpty()) {
            return null;
        }
        File directory = opt.get();
        return Helper.createDownloadBuilder(directory, String.format("--link --temp %s", url));
    }

    public class PingRunner
    implements Runnable {
        long interval = 30000L;

        @Override
        public void run() {
            while (EndPoint.this.session.isOpen()) {
                try {
                    EndPoint.this.session.getBasicRemote().sendPing(ByteBuffer.allocate(0));
                }
                catch (IOException | IllegalArgumentException e) {
                    try {
                        EndPoint.this.session.close(new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, "Ping failed."));
                    }
                    catch (IOException e1) {
                        ANSI.error("Ping fail: Close session failed.", e);
                        ANSI.prompt();
                    }
                    break;
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    ANSI.error("Ping fail: Thread interrupted.", e);
                    ANSI.prompt();
                }
            }
        }
    }

    private static enum STATUS {
        ACCEPT("{ACP}"),
        INFO("{INF}"),
        READY("{RDY}"),
        ERROR("{ERR}");

        public final String value;

        private STATUS(String string2) {
            this.value = string2;
        }
    }
}

