/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.automod;

import discord4j.core.GatewayDiscordClient;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AutoModRuleTriggerMetaData {
    private final GatewayDiscordClient gateway;
    private final AutoModTriggerMetaData data;

    public AutoModRuleTriggerMetaData(GatewayDiscordClient gateway, AutoModTriggerMetaData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public AutoModTriggerMetaData getData() {
        return this.data;
    }

    public List<String> getKeywordFilter() {
        return this.data.keywordFilter().toOptional().orElse(Collections.emptyList());
    }

    public List<String> getAllowedFilter() {
        return this.data.allowList().toOptional().orElse(Collections.emptyList());
    }

    public List<Pattern> getRegexPatterns() {
        return this.data.regexPatterns().toOptional().map(listRegexPatterns -> listRegexPatterns.stream().map(Pattern::compile).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public Optional<Integer> getMentionLimit() {
        return this.data.mentionTotalLimit().toOptional();
    }

    public boolean isMentionRaidProtectionEnabled() {
        return this.data.mentionRaidProtectionEnabled().toOptional().orElse(false);
    }

    public EnumSet<Preset> getPresets() {
        EnumSet<Preset> presets = EnumSet.noneOf(Preset.class);
        if (this.data.presets().isAbsent()) {
            return presets;
        }
        presets.addAll(this.data.presets().toOptional().map(presetValues -> presetValues.stream().map(Preset::of)).orElse(Stream.empty()).collect(Collectors.toList()));
        return presets;
    }

    public static enum Preset {
        UNKNOWN(-1),
        PROFANITY(1),
        SEXUAL_CONTENT(2),
        SLURS(3);

        private final int value;

        private Preset(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Preset of(int value) {
            for (Preset preset : Preset.values()) {
                if (preset.getValue() != value) continue;
                return preset;
            }
            return UNKNOWN;
        }
    }
}

