/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.servicer;

import com.austinv11.servicer.WireService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.austinv11.servicer.WireService"})
public class ServicerProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elements;
    private Filer filer;
    private Messager messager;
    private final Map<String, Services> services = new HashMap<String, Services>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public synchronized boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(WireService.class)) {
            WireService[] serviceAnnotations;
            if (element.getKind() != ElementKind.CLASS) continue;
            for (WireService service : serviceAnnotations = (WireService[])element.getAnnotationsByType(WireService.class)) {
                String serviceName;
                try {
                    serviceName = service.value().getCanonicalName();
                }
                catch (MirroredTypeException e) {
                    serviceName = e.getTypeMirror().toString();
                }
                this.services.computeIfAbsent(serviceName, name -> new Services()).add(element);
            }
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Found " + this.services.size() + " services!\n");
        if (!roundEnv.processingOver()) {
            return true;
        }
        this.services.forEach((k, s2) -> {
            Throwable throwable;
            FileObject fo;
            String serviceLocation = "META-INF/services/" + k;
            ArrayList oldServices = new ArrayList();
            try {
                fo = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", serviceLocation);
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(fo.openInputStream(), StandardCharsets.UTF_8));){
                    reader.lines().map(line -> {
                        int comment = line.indexOf("#");
                        return (comment >= 0 ? line.substring(0, comment) : line).trim();
                    }).filter(line -> !line.isEmpty()).forEach(oldServices::add);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                fo.delete();
            }
            catch (Throwable e) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, serviceLocation + " does not yet exist!\n");
            }
            try {
                fo = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", serviceLocation, s2.getElements(this.elements));
                throwable = null;
                try (OutputStreamWriter w = new OutputStreamWriter(fo.openOutputStream());){
                    for (String oldService : oldServices) {
                        w.append(oldService).append("\n");
                    }
                    for (String impl : s2.getImpls()) {
                        this.messager.printMessage(Diagnostic.Kind.NOTE, "Setting up " + impl + " for use as a " + k + " implementation!\n");
                        w.append(impl).append("\n");
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable e) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Error caught attempting to process services.\n");
            }
        });
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return super.getSupportedSourceVersion();
    }

    private static class Services {
        private final Set<String> impls = new HashSet<String>();

        private Services() {
        }

        void add(Element annotated) {
            this.impls.add(annotated.asType().toString());
        }

        Collection<String> getImpls() {
            return this.impls;
        }

        Element[] getElements(Elements elements) {
            return (Element[])this.impls.stream().map(elements::getTypeElement).toArray(Element[]::new);
        }
    }
}

