/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegFileLoader;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;

public class YoutubeMpegStreamAudioTrack
extends MpegAudioTrack {
    private static final RequestConfig streamingRequestConfig = RequestConfig.custom().setConnectTimeout(10000).build();
    private static final long EMPTY_RETRY_THRESHOLD_MS = 400L;
    private static final long EMPTY_RETRY_INTERVAL_MS = 50L;
    private final HttpInterface httpInterface;
    private final URI signedUrl;

    public YoutubeMpegStreamAudioTrack(AudioTrackInfo trackInfo, HttpInterface httpInterface, URI signedUrl) {
        super(trackInfo, null);
        this.httpInterface = httpInterface;
        this.signedUrl = signedUrl;
        httpInterface.getContext().setRequestConfig(streamingRequestConfig);
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) {
        localExecutor.executeProcessingLoop(() -> this.execute(localExecutor), null);
    }

    private void execute(LocalAudioTrackExecutor localExecutor) throws InterruptedException {
        TrackState state = new TrackState(this.signedUrl);
        try {
            while (!state.finished) {
                this.processNextSegmentWithRetry(localExecutor, state);
                state.relativeSequence++;
            }
        }
        finally {
            if (state.trackConsumer != null) {
                state.trackConsumer.close();
            }
        }
    }

    private void processNextSegmentWithRetry(LocalAudioTrackExecutor localExecutor, TrackState state) throws InterruptedException {
        long waitStart;
        if (this.processNextSegment(localExecutor, state)) {
            return;
        }
        long iterationStart = waitStart = System.currentTimeMillis();
        while (!this.processNextSegment(localExecutor, state)) {
            if (iterationStart - waitStart >= 400L) {
                state.finished = true;
                break;
            }
            Thread.sleep(50L);
            iterationStart = System.currentTimeMillis();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processNextSegment(LocalAudioTrackExecutor localExecutor, TrackState state) throws InterruptedException {
        URI segmentUrl = this.getNextSegmentUrl(state);
        try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(this.httpInterface, segmentUrl, Long.MAX_VALUE);){
            if (stream.checkStatusCode() == 204 || stream.getContentLength() == 0L) {
                boolean bl = false;
                return bl;
            }
            state.baseUrl = this.httpInterface.getFinalLocation();
            this.processSegmentStream(stream, localExecutor.getProcessingContext(), state);
            stream.releaseConnection();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processSegmentStream(SeekableInputStream stream, AudioProcessingContext context, TrackState state) throws InterruptedException {
        MpegFileTrackProvider fileReader;
        MpegFileLoader file = new MpegFileLoader(stream);
        file.parseHeaders();
        state.absoluteSequence = this.extractAbsoluteSequenceFromEvent(file.getLastEventMessage());
        if (state.trackConsumer == null) {
            state.trackConsumer = this.loadAudioTrack(file, context);
        }
        if ((fileReader = file.loadReader(state.trackConsumer)) == null) {
            throw new FriendlyException("Unknown MP4 format.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        fileReader.provideFrames();
    }

    private URI getNextSegmentUrl(TrackState state) {
        URIBuilder builder = new URIBuilder(state.baseUrl).setParameter("rn", String.valueOf(state.relativeSequence)).setParameter("rbuf", "0");
        if (state.absoluteSequence != null) {
            builder.setParameter("sq", String.valueOf(state.absoluteSequence + 1L));
        }
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Long extractAbsoluteSequenceFromEvent(byte[] data) {
        if (data == null) {
            return null;
        }
        String message = new String(data, StandardCharsets.UTF_8);
        String sequence = DataFormatTools.extractBetween(message, "Sequence-Number: ", "\r\n");
        return sequence != null ? Long.valueOf(sequence) : null;
    }

    private static class TrackState {
        private long relativeSequence;
        private Long absoluteSequence;
        private MpegTrackConsumer trackConsumer;
        private boolean finished;
        private URI baseUrl;

        public TrackState(URI baseUrl) {
            this.baseUrl = baseUrl;
        }
    }
}

