/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.GuildCreateFields;
import discord4j.core.spec.GuildCreateSpecGenerator;
import discord4j.core.spec.ImmutableGuildCreateFields;
import discord4j.core.spec.RoleCreateSpec;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildCreateSpecGenerator", generator="Immutables")
public final class GuildCreateSpec
implements GuildCreateSpecGenerator {
    private final String name;
    private final Region region;
    @Nullable
    private final Image icon;
    private final Guild.VerificationLevel verificationLevel;
    private final Guild.NotificationLevel defaultMessageNotificationLevel;
    private final Guild.ContentFilterLevel explicitContentFilter;
    private final List<RoleCreateSpec> roles;
    @Nullable
    private final RoleCreateSpec everyoneRole;
    private final List<GuildCreateFields.PartialChannel> channels;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private GuildCreateSpec(String name, Region region) {
        this.name = Objects.requireNonNull(name, "name");
        this.region = Objects.requireNonNull(region, "region");
        this.icon = null;
        this.everyoneRole = null;
        this.verificationLevel = this.initShim.verificationLevel();
        this.defaultMessageNotificationLevel = this.initShim.defaultMessageNotificationLevel();
        this.explicitContentFilter = this.initShim.explicitContentFilter();
        this.roles = this.initShim.roles();
        this.channels = this.initShim.channels();
        this.initShim = null;
    }

    private GuildCreateSpec(Builder builder) {
        this.name = builder.name;
        this.region = builder.region;
        this.icon = builder.icon;
        this.everyoneRole = builder.everyoneRole;
        if (builder.verificationLevel != null) {
            this.initShim.verificationLevel(builder.verificationLevel);
        }
        if (builder.defaultMessageNotificationLevel != null) {
            this.initShim.defaultMessageNotificationLevel(builder.defaultMessageNotificationLevel);
        }
        if (builder.explicitContentFilter != null) {
            this.initShim.explicitContentFilter(builder.explicitContentFilter);
        }
        if (builder.rolesIsSet()) {
            this.initShim.roles(GuildCreateSpec.createUnmodifiableList(true, builder.roles));
        }
        if (builder.channelsIsSet()) {
            this.initShim.channels(GuildCreateSpec.createUnmodifiableList(true, builder.channels));
        }
        this.verificationLevel = this.initShim.verificationLevel();
        this.defaultMessageNotificationLevel = this.initShim.defaultMessageNotificationLevel();
        this.explicitContentFilter = this.initShim.explicitContentFilter();
        this.roles = this.initShim.roles();
        this.channels = this.initShim.channels();
        this.initShim = null;
    }

    private GuildCreateSpec(String name, Region region, @Nullable Image icon, Guild.VerificationLevel verificationLevel, Guild.NotificationLevel defaultMessageNotificationLevel, Guild.ContentFilterLevel explicitContentFilter, List<RoleCreateSpec> roles, @Nullable RoleCreateSpec everyoneRole, List<GuildCreateFields.PartialChannel> channels) {
        this.name = name;
        this.region = region;
        this.icon = icon;
        this.verificationLevel = verificationLevel;
        this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
        this.explicitContentFilter = explicitContentFilter;
        this.roles = roles;
        this.everyoneRole = everyoneRole;
        this.channels = channels;
        this.initShim = null;
    }

    private Guild.VerificationLevel verificationLevelInitialize() {
        return GuildCreateSpecGenerator.super.verificationLevel();
    }

    private Guild.NotificationLevel defaultMessageNotificationLevelInitialize() {
        return GuildCreateSpecGenerator.super.defaultMessageNotificationLevel();
    }

    private Guild.ContentFilterLevel explicitContentFilterInitialize() {
        return GuildCreateSpecGenerator.super.explicitContentFilter();
    }

    private List<RoleCreateSpec> rolesInitialize() {
        return GuildCreateSpecGenerator.super.roles();
    }

    private List<GuildCreateFields.PartialChannel> channelsInitialize() {
        return GuildCreateSpecGenerator.super.channels();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    @Nullable
    public Image icon() {
        return this.icon;
    }

    @Override
    public Guild.VerificationLevel verificationLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verificationLevel() : this.verificationLevel;
    }

    @Override
    public Guild.NotificationLevel defaultMessageNotificationLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultMessageNotificationLevel() : this.defaultMessageNotificationLevel;
    }

    @Override
    public Guild.ContentFilterLevel explicitContentFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.explicitContentFilter() : this.explicitContentFilter;
    }

    @Override
    public List<RoleCreateSpec> roles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.roles() : this.roles;
    }

    @Override
    @Nullable
    public RoleCreateSpec everyoneRole() {
        return this.everyoneRole;
    }

    @Override
    public List<GuildCreateFields.PartialChannel> channels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.channels() : this.channels;
    }

    public final GuildCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildCreateSpec(newValue, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withRegion(Region value) {
        if (this.region == value) {
            return this;
        }
        Region newValue = Objects.requireNonNull(value, "region");
        return new GuildCreateSpec(this.name, newValue, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withIcon(@Nullable Image value) {
        if (this.icon == value) {
            return this;
        }
        return new GuildCreateSpec(this.name, this.region, value, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withVerificationLevel(Guild.VerificationLevel value) {
        Guild.VerificationLevel newValue = Objects.requireNonNull(value, "verificationLevel");
        if (this.verificationLevel == newValue) {
            return this;
        }
        return new GuildCreateSpec(this.name, this.region, this.icon, newValue, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withDefaultMessageNotificationLevel(Guild.NotificationLevel value) {
        Guild.NotificationLevel newValue = Objects.requireNonNull(value, "defaultMessageNotificationLevel");
        if (this.defaultMessageNotificationLevel == newValue) {
            return this;
        }
        return new GuildCreateSpec(this.name, this.region, this.icon, this.verificationLevel, newValue, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withExplicitContentFilter(Guild.ContentFilterLevel value) {
        Guild.ContentFilterLevel newValue = Objects.requireNonNull(value, "explicitContentFilter");
        if (this.explicitContentFilter == newValue) {
            return this;
        }
        return new GuildCreateSpec(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, newValue, this.roles, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withRoles(RoleCreateSpec ... elements) {
        List<RoleCreateSpec> newValue = GuildCreateSpec.createUnmodifiableList(false, GuildCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return new GuildCreateSpec(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, newValue, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withRoles(Iterable<? extends RoleCreateSpec> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<RoleCreateSpec> newValue = GuildCreateSpec.createUnmodifiableList(false, GuildCreateSpec.createSafeList(elements, true, false));
        return new GuildCreateSpec(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, newValue, this.everyoneRole, this.channels);
    }

    public final GuildCreateSpec withEveryoneRole(@Nullable RoleCreateSpec value) {
        if (this.everyoneRole == value) {
            return this;
        }
        return new GuildCreateSpec(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, value, this.channels);
    }

    public final GuildCreateSpec withChannels(GuildCreateFields.PartialChannel ... elements) {
        List<GuildCreateFields.PartialChannel> newValue = GuildCreateSpec.createUnmodifiableList(false, GuildCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return new GuildCreateSpec(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, newValue);
    }

    public final GuildCreateSpec withChannels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
        if (this.channels == elements) {
            return this;
        }
        List<GuildCreateFields.PartialChannel> newValue = GuildCreateSpec.createUnmodifiableList(false, GuildCreateSpec.createSafeList(elements, true, false));
        return new GuildCreateSpec(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildCreateSpec && this.equalTo(0, (GuildCreateSpec)another);
    }

    private boolean equalTo(int synthetic, GuildCreateSpec another) {
        return this.name.equals(another.name) && this.region.equals(another.region) && Objects.equals(this.icon, another.icon) && this.verificationLevel.equals((Object)another.verificationLevel) && this.defaultMessageNotificationLevel.equals((Object)another.defaultMessageNotificationLevel) && this.explicitContentFilter.equals((Object)another.explicitContentFilter) && this.roles.equals(another.roles) && Objects.equals(this.everyoneRole, another.everyoneRole) && this.channels.equals(another.channels);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.region.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.icon);
        h2 += (h2 << 5) + this.verificationLevel.hashCode();
        h2 += (h2 << 5) + this.defaultMessageNotificationLevel.hashCode();
        h2 += (h2 << 5) + this.explicitContentFilter.hashCode();
        h2 += (h2 << 5) + this.roles.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.everyoneRole);
        h2 += (h2 << 5) + this.channels.hashCode();
        return h2;
    }

    public String toString() {
        return "GuildCreateSpec{name=" + this.name + ", region=" + this.region + ", icon=" + this.icon + ", verificationLevel=" + (Object)((Object)this.verificationLevel) + ", defaultMessageNotificationLevel=" + (Object)((Object)this.defaultMessageNotificationLevel) + ", explicitContentFilter=" + (Object)((Object)this.explicitContentFilter) + ", roles=" + this.roles + ", everyoneRole=" + this.everyoneRole + ", channels=" + this.channels + "}";
    }

    public static GuildCreateSpec of(String name, Region region) {
        return new GuildCreateSpec(name, region);
    }

    static GuildCreateSpec copyOf(GuildCreateSpecGenerator instance) {
        if (instance instanceof GuildCreateSpec) {
            return (GuildCreateSpec)instance;
        }
        return GuildCreateSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_REGION = 2L;
        private static final long OPT_BIT_ROLES = 1L;
        private static final long OPT_BIT_CHANNELS = 2L;
        private long initBits = 3L;
        private long optBits;
        private String name;
        private Region region;
        private Image icon;
        private Guild.VerificationLevel verificationLevel;
        private Guild.NotificationLevel defaultMessageNotificationLevel;
        private Guild.ContentFilterLevel explicitContentFilter;
        private List<RoleCreateSpec> roles = new ArrayList<RoleCreateSpec>();
        private RoleCreateSpec everyoneRole;
        private List<GuildCreateFields.PartialChannel> channels = new ArrayList<GuildCreateFields.PartialChannel>();

        private Builder() {
        }

        public final Builder from(GuildCreateSpec instance) {
            return this.from((GuildCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GuildCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.region(instance.region());
            Image iconValue = instance.icon();
            if (iconValue != null) {
                this.icon(iconValue);
            }
            this.verificationLevel(instance.verificationLevel());
            this.defaultMessageNotificationLevel(instance.defaultMessageNotificationLevel());
            this.explicitContentFilter(instance.explicitContentFilter());
            this.addAllRoles(instance.roles());
            RoleCreateSpec everyoneRoleValue = instance.everyoneRole();
            if (everyoneRoleValue != null) {
                this.everyoneRole(everyoneRoleValue);
            }
            this.addAllChannels(instance.channels());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(Region region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder icon(@Nullable Image icon) {
            this.icon = icon;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder verificationLevel(Guild.VerificationLevel verificationLevel) {
            this.verificationLevel = Objects.requireNonNull(verificationLevel, "verificationLevel");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultMessageNotificationLevel(Guild.NotificationLevel defaultMessageNotificationLevel) {
            this.defaultMessageNotificationLevel = Objects.requireNonNull(defaultMessageNotificationLevel, "defaultMessageNotificationLevel");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder explicitContentFilter(Guild.ContentFilterLevel explicitContentFilter) {
            this.explicitContentFilter = Objects.requireNonNull(explicitContentFilter, "explicitContentFilter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRole(RoleCreateSpec element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(RoleCreateSpec ... elements) {
            for (RoleCreateSpec element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Iterable<? extends RoleCreateSpec> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<? extends RoleCreateSpec> elements) {
            for (RoleCreateSpec roleCreateSpec : elements) {
                this.roles.add(Objects.requireNonNull(roleCreateSpec, "roles element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder everyoneRole(@Nullable RoleCreateSpec everyoneRole) {
            this.everyoneRole = everyoneRole;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChannel(GuildCreateFields.PartialChannel element) {
            element = ImmutableGuildCreateFields.PartialChannel.copyOf(element);
            this.channels.add(Objects.requireNonNull(element, "channels element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addChannel(String name, Channel.Type type) {
            return this.addChannel(ImmutableGuildCreateFields.PartialChannel.of(name, type));
        }

        @CanIgnoreReturnValue
        public final Builder addChannels(GuildCreateFields.PartialChannel ... elements) {
            for (GuildCreateFields.PartialChannel element : elements) {
                element = ImmutableGuildCreateFields.PartialChannel.copyOf(element);
                this.channels.add(Objects.requireNonNull(element, "channels element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
            this.channels.clear();
            return this.addAllChannels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChannels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
            for (GuildCreateFields.PartialChannel partialChannel : elements) {
                ImmutableGuildCreateFields.PartialChannel partialChannel2 = ImmutableGuildCreateFields.PartialChannel.copyOf(partialChannel);
                this.channels.add(Objects.requireNonNull(partialChannel2, "channels element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public GuildCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GuildCreateSpec(this);
        }

        private boolean rolesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean channelsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("region");
            }
            return "Cannot build GuildCreateSpec, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GuildCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte verificationLevelBuildStage = 0;
        private Guild.VerificationLevel verificationLevel;
        private byte defaultMessageNotificationLevelBuildStage = 0;
        private Guild.NotificationLevel defaultMessageNotificationLevel;
        private byte explicitContentFilterBuildStage = 0;
        private Guild.ContentFilterLevel explicitContentFilter;
        private byte rolesBuildStage = 0;
        private List<RoleCreateSpec> roles;
        private byte channelsBuildStage = 0;
        private List<GuildCreateFields.PartialChannel> channels;

        private InitShim() {
        }

        Guild.VerificationLevel verificationLevel() {
            if (this.verificationLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verificationLevelBuildStage == 0) {
                this.verificationLevelBuildStage = (byte)-1;
                this.verificationLevel = Objects.requireNonNull(GuildCreateSpec.this.verificationLevelInitialize(), "verificationLevel");
                this.verificationLevelBuildStage = 1;
            }
            return this.verificationLevel;
        }

        void verificationLevel(Guild.VerificationLevel verificationLevel) {
            this.verificationLevel = verificationLevel;
            this.verificationLevelBuildStage = 1;
        }

        Guild.NotificationLevel defaultMessageNotificationLevel() {
            if (this.defaultMessageNotificationLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultMessageNotificationLevelBuildStage == 0) {
                this.defaultMessageNotificationLevelBuildStage = (byte)-1;
                this.defaultMessageNotificationLevel = Objects.requireNonNull(GuildCreateSpec.this.defaultMessageNotificationLevelInitialize(), "defaultMessageNotificationLevel");
                this.defaultMessageNotificationLevelBuildStage = 1;
            }
            return this.defaultMessageNotificationLevel;
        }

        void defaultMessageNotificationLevel(Guild.NotificationLevel defaultMessageNotificationLevel) {
            this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
            this.defaultMessageNotificationLevelBuildStage = 1;
        }

        Guild.ContentFilterLevel explicitContentFilter() {
            if (this.explicitContentFilterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.explicitContentFilterBuildStage == 0) {
                this.explicitContentFilterBuildStage = (byte)-1;
                this.explicitContentFilter = Objects.requireNonNull(GuildCreateSpec.this.explicitContentFilterInitialize(), "explicitContentFilter");
                this.explicitContentFilterBuildStage = 1;
            }
            return this.explicitContentFilter;
        }

        void explicitContentFilter(Guild.ContentFilterLevel explicitContentFilter) {
            this.explicitContentFilter = explicitContentFilter;
            this.explicitContentFilterBuildStage = 1;
        }

        List<RoleCreateSpec> roles() {
            if (this.rolesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rolesBuildStage == 0) {
                this.rolesBuildStage = (byte)-1;
                this.roles = GuildCreateSpec.createUnmodifiableList(false, GuildCreateSpec.createSafeList(GuildCreateSpec.this.rolesInitialize(), true, false));
                this.rolesBuildStage = 1;
            }
            return this.roles;
        }

        void roles(List<RoleCreateSpec> roles) {
            this.roles = roles;
            this.rolesBuildStage = 1;
        }

        List<GuildCreateFields.PartialChannel> channels() {
            if (this.channelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.channelsBuildStage == 0) {
                this.channelsBuildStage = (byte)-1;
                this.channels = GuildCreateSpec.createUnmodifiableList(false, GuildCreateSpec.createSafeList(GuildCreateSpec.this.channelsInitialize(), true, false));
                this.channelsBuildStage = 1;
            }
            return this.channels;
        }

        void channels(List<GuildCreateFields.PartialChannel> channels) {
            this.channels = channels;
            this.channelsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.verificationLevelBuildStage == -1) {
                attributes.add("verificationLevel");
            }
            if (this.defaultMessageNotificationLevelBuildStage == -1) {
                attributes.add("defaultMessageNotificationLevel");
            }
            if (this.explicitContentFilterBuildStage == -1) {
                attributes.add("explicitContentFilter");
            }
            if (this.rolesBuildStage == -1) {
                attributes.add("roles");
            }
            if (this.channelsBuildStage == -1) {
                attributes.add("channels");
            }
            return "Cannot build GuildCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

