/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.common.LogUtil;
import discord4j.common.close.CloseStatus;
import discord4j.common.close.DisconnectBehavior;
import discord4j.common.sinks.EmissionStrategy;
import discord4j.voice.retry.PartialDisconnectException;
import discord4j.voice.retry.VoiceGatewayException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.ContextView;
import reactor.util.function.Tuple2;

public class VoiceWebsocketHandler {
    private static final Logger log = Loggers.getLogger(VoiceWebsocketHandler.class);
    private final Sinks.Many<ByteBuf> inbound;
    private final Flux<ByteBuf> outbound;
    private final Sinks.One<DisconnectBehavior> sessionClose;
    private final ContextView context;
    private final EmissionStrategy emissionStrategy;

    public VoiceWebsocketHandler(Sinks.Many<ByteBuf> inbound, Flux<ByteBuf> outbound, ContextView context) {
        this.inbound = inbound;
        this.outbound = outbound;
        this.sessionClose = Sinks.one();
        this.context = context;
        this.emissionStrategy = EmissionStrategy.park(Duration.ofNanos(10L));
    }

    public Mono<Tuple2<DisconnectBehavior, CloseStatus>> handle(WebsocketInbound in, WebsocketOutbound out) {
        Mono<CloseWebSocketFrame> outboundClose = this.sessionClose.asMono().doOnNext(behavior -> log.debug(LogUtil.format(this.context, "Closing session with behavior: {}"), behavior)).flatMap(behavior -> {
            switch (behavior.getAction()) {
                case RETRY_ABRUPTLY: 
                case STOP_ABRUPTLY: {
                    return Mono.error(behavior.getCause() != null ? behavior.getCause() : new PartialDisconnectException(this.context));
                }
            }
            return Mono.just(CloseStatus.NORMAL_CLOSE);
        }).map(status -> new CloseWebSocketFrame(status.getCode(), (String)status.getReason().orElse(null)));
        Mono<CloseStatus> inboundClose = in.receiveCloseStatus().map(status -> new CloseStatus(status.code(), status.reasonText())).doOnNext(status -> {
            log.debug(LogUtil.format(this.context, "Received close status: {}"), status);
            this.close(DisconnectBehavior.retryAbruptly(new VoiceGatewayException(this.context, "Inbound close status")));
        });
        Mono<Void> outboundEvents = out.sendObject(Flux.merge(outboundClose, this.outbound.map(TextWebSocketFrame::new))).then();
        in.withConnection(c -> c.onDispose(() -> log.debug(LogUtil.format(this.context, "Connection disposed"))));
        Mono<Void> inboundEvents = in.aggregateFrames().receiveFrames().map(DefaultByteBufHolder::content).doOnNext(this::emitInbound).then();
        return Mono.zip(outboundEvents, inboundEvents).doOnError(this::error).onErrorResume(t -> t.getCause() instanceof VoiceGatewayException, t -> Mono.empty()).then(Mono.zip(this.sessionClose.asMono(), inboundClose.defaultIfEmpty(CloseStatus.ABNORMAL_CLOSE)));
    }

    private void emitInbound(ByteBuf value) {
        this.emissionStrategy.emitNext(this.inbound, value);
    }

    public void close() {
        this.close(DisconnectBehavior.retry(null));
    }

    public void close(DisconnectBehavior behavior) {
        this.sessionClose.emitValue(behavior, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    public void error(Throwable error) {
        log.info(LogUtil.format(this.context, "Triggering error sequence: {}"), error.toString());
        this.close(DisconnectBehavior.retryAbruptly(error));
    }
}

