/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter.converter;

import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.filter.converter.ConverterAudioFilter;
import java.nio.ShortBuffer;

public class ToShortAudioFilter
extends ConverterAudioFilter {
    private final ShortPcmAudioFilter downstream;
    private final int channelCount;
    private final short[] outputBuffer;

    public ToShortAudioFilter(ShortPcmAudioFilter downstream, int channelCount) {
        this.downstream = downstream;
        this.channelCount = channelCount;
        this.outputBuffer = new short[4096 * channelCount];
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        int end = offset + length;
        while (offset < end) {
            int chunkSize = Math.min(4096, end - offset);
            int writePosition = 0;
            for (int chunkPosition = 0; chunkPosition < chunkSize; ++chunkPosition) {
                for (int channel = 0; channel < this.channelCount; ++channel) {
                    this.outputBuffer[writePosition++] = ToShortAudioFilter.floatToShort(input[channel][chunkPosition]);
                }
            }
            offset += chunkSize;
            this.downstream.process(this.outputBuffer, 0, chunkSize);
        }
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        this.downstream.process(input, offset, length);
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        this.downstream.process(buffer);
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        int end = offset + length;
        while (offset < end) {
            int chunkSize = Math.min(4096, end - offset);
            int writePosition = 0;
            for (int chunkPosition = 0; chunkPosition < chunkSize; ++chunkPosition) {
                for (int channel = 0; channel < this.channelCount; ++channel) {
                    this.outputBuffer[writePosition++] = input[channel][chunkPosition];
                }
            }
            offset += chunkSize;
            this.downstream.process(this.outputBuffer, 0, chunkSize);
        }
    }
}

