/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHelper;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudM3uAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudM3uInfo;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundCloudAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(SoundCloudAudioTrack.class);
    private final SoundCloudAudioSourceManager sourceManager;

    public SoundCloudAudioTrack(AudioTrackInfo trackInfo, SoundCloudAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            this.playFromIdentifier(httpInterface, this.trackInfo.identifier, false, localExecutor);
        }
    }

    private void playFromIdentifier(HttpInterface httpInterface, String identifier, boolean recursion, LocalAudioTrackExecutor localExecutor) throws Exception {
        SoundCloudM3uInfo m3uInfo = this.sourceManager.getFormatHandler().getM3uInfo(identifier);
        if (m3uInfo != null) {
            this.processDelegate(new SoundCloudM3uAudioTrack(this.trackInfo, httpInterface, m3uInfo), localExecutor);
            return;
        }
        String mp3LookupUrl = this.sourceManager.getFormatHandler().getMp3LookupUrl(identifier);
        if (mp3LookupUrl != null) {
            String playbackUrl = SoundCloudHelper.loadPlaybackUrl(httpInterface, identifier.substring(2));
            this.loadFromMp3Url(localExecutor, httpInterface, playbackUrl);
            return;
        }
        if (!recursion) {
            AudioTrack track = this.sourceManager.loadFromTrackPage(this.trackInfo.uri);
            this.playFromIdentifier(httpInterface, track.getIdentifier(), true, localExecutor);
        }
    }

    private void loadFromMp3Url(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, String trackUrl) throws Exception {
        log.debug("Starting SoundCloud track from URL: {}", (Object)trackUrl);
        try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(trackUrl), null);){
            if (!HttpClientTools.isSuccessWithContent(stream.checkStatusCode())) {
                throw new IOException("Invalid status code for soundcloud stream: " + stream.checkStatusCode());
            }
            this.processDelegate(new Mp3AudioTrack(this.trackInfo, stream), localExecutor);
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new SoundCloudAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

