/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.GuildTemplateCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildTemplateCreateSpecGenerator", generator="Immutables")
public final class GuildTemplateCreateSpec
implements GuildTemplateCreateSpecGenerator {
    private final String name;
    private final String description_value;
    private final boolean description_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private GuildTemplateCreateSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        Possible description$impl = Possible.absent();
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    private GuildTemplateCreateSpec(String name, Possible<Optional<String>> description) {
        this.name = name;
        Possible description$impl = description;
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Optional<String>> description() {
        return this.description_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.description_value));
    }

    public final GuildTemplateCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildTemplateCreateSpec(newValue, this.description());
    }

    public GuildTemplateCreateSpec withDescription(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new GuildTemplateCreateSpec(this.name, newValue);
    }

    @Deprecated
    public GuildTemplateCreateSpec withDescription(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new GuildTemplateCreateSpec(this.name, newValue);
    }

    public GuildTemplateCreateSpec withDescriptionOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new GuildTemplateCreateSpec(this.name, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildTemplateCreateSpec && this.equalTo(0, (GuildTemplateCreateSpec)another);
    }

    private boolean equalTo(int synthetic, GuildTemplateCreateSpec another) {
        return this.name.equals(another.name) && this.description().equals(another.description());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.description().hashCode();
        return h2;
    }

    public String toString() {
        return "GuildTemplateCreateSpec{name=" + this.name + ", description=" + this.description().toString() + "}";
    }

    public static GuildTemplateCreateSpec of(String name) {
        return new GuildTemplateCreateSpec(name);
    }

    static GuildTemplateCreateSpec copyOf(GuildTemplateCreateSpecGenerator instance) {
        if (instance instanceof GuildTemplateCreateSpec) {
            return (GuildTemplateCreateSpec)instance;
        }
        return GuildTemplateCreateSpec.builder().from(instance).build();
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GuildTemplateCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Optional<String>> description_possible = Possible.absent();
        private String name;

        private Builder() {
        }

        public final Builder from(GuildTemplateCreateSpec instance) {
            return this.from((GuildTemplateCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GuildTemplateCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.description(instance.description());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder description(Possible<Optional<String>> value) {
            this.description_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder description(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder descriptionOrNull(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public GuildTemplateCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GuildTemplateCreateSpec(this.name, this.description_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build GuildTemplateCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> description_build() {
            return this.description_possible;
        }
    }

    @Generated(from="GuildTemplateCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildTemplateCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

