/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.ImmutableAllowedMentionsData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class AllowedMentions {
    private final Possible<Set<Type>> parse;
    private final Possible<Set<Snowflake>> userIds;
    private final Possible<Set<Snowflake>> roleIds;
    private final Possible<Boolean> repliedUser;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AllowedMentions template) {
        return new Builder(template.parse, template.userIds, template.roleIds, template.repliedUser);
    }

    public static AllowedMentions suppressAll() {
        return AllowedMentions.builder().build();
    }

    public static AllowedMentions suppressEveryone() {
        return AllowedMentions.builder().parseType(Type.USER, Type.ROLE).build();
    }

    private AllowedMentions(Possible<Set<Type>> parse, Possible<Set<Snowflake>> userIds, Possible<Set<Snowflake>> roleIds, Possible<Boolean> repliedUser) {
        this.parse = parse;
        this.userIds = userIds;
        this.roleIds = roleIds;
        this.repliedUser = repliedUser;
    }

    private <T, U> List<T> mapSetToList(Set<U> list, Function<? super U, ? extends T> mapper) {
        ArrayList data = new ArrayList(list.size());
        list.forEach(u -> data.add(mapper.apply((Object)u)));
        return data;
    }

    public Builder mutate() {
        return new Builder(this.parse, this.userIds, this.roleIds, this.repliedUser);
    }

    public AllowedMentionsData toData() {
        ImmutableAllowedMentionsData.Builder builder = AllowedMentionsData.builder();
        if (!this.parse.isAbsent()) {
            builder.parse(this.mapSetToList(this.parse.get(), Type::getRaw));
        }
        if (!this.userIds.isAbsent()) {
            builder.users(this.mapSetToList(this.userIds.get(), Snowflake::asString));
        }
        if (!this.roleIds.isAbsent()) {
            builder.roles(this.mapSetToList(this.roleIds.get(), Snowflake::asString));
        }
        if (this.parse.isAbsent() && this.userIds.isAbsent() && this.roleIds.isAbsent()) {
            builder.parse(Collections.emptyList());
        }
        if (!this.repliedUser.isAbsent()) {
            builder.repliedUser(this.repliedUser.get());
        }
        return builder.build();
    }

    public static enum Type {
        ROLE("roles"),
        USER("users"),
        EVERYONE_AND_HERE("everyone");

        private final String raw;

        private Type(String raw) {
            this.raw = raw;
        }

        public String getRaw() {
            return this.raw;
        }
    }

    public static class Builder {
        private Possible<Set<Type>> parse;
        private Possible<Set<Snowflake>> userIds;
        private Possible<Set<Snowflake>> roleIds;
        private Possible<Boolean> repliedUser;

        private Builder() {
            this(Possible.absent(), Possible.absent(), Possible.absent(), Possible.absent());
        }

        private Builder(Possible<Set<Type>> parse, Possible<Set<Snowflake>> userIds, Possible<Set<Snowflake>> roleIds, Possible<Boolean> repliedUser) {
            this.parse = parse;
            this.userIds = userIds;
            this.roleIds = roleIds;
            this.repliedUser = repliedUser;
        }

        public Builder parseType(Type type) {
            if (this.parse.isAbsent()) {
                this.parse = Possible.of(new HashSet());
            }
            this.parse.get().add(type);
            return this;
        }

        public Builder allowUser(Snowflake userId) {
            if (this.userIds.isAbsent()) {
                this.userIds = Possible.of(new HashSet());
            }
            this.userIds.get().add(userId);
            return this;
        }

        public Builder allowRole(Snowflake roleId) {
            if (this.roleIds.isAbsent()) {
                this.roleIds = Possible.of(new HashSet());
            }
            this.roleIds.get().add(roleId);
            return this;
        }

        public Builder parseType(Type ... type) {
            if (this.parse.isAbsent()) {
                this.parse = Possible.of(new HashSet());
            }
            this.parse.get().addAll(Arrays.asList(type));
            return this;
        }

        public Builder allowUser(Snowflake ... userId) {
            if (this.userIds.isAbsent()) {
                this.userIds = Possible.of(new HashSet());
            }
            this.userIds.get().addAll(Arrays.asList(userId));
            return this;
        }

        public Builder allowRole(Snowflake ... roleId) {
            if (this.roleIds.isAbsent()) {
                this.roleIds = Possible.of(new HashSet());
            }
            this.roleIds.get().addAll(Arrays.asList(roleId));
            return this;
        }

        public Builder repliedUser(boolean repliedUser) {
            this.repliedUser = Possible.of(repliedUser);
            return this;
        }

        public AllowedMentions build() {
            return new AllowedMentions(this.parse, this.userIds, this.roleIds, this.repliedUser);
        }
    }
}

