/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.delegating;

import discord4j.store.api.Store;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class DelegatingStore<K extends Comparable<K>, V>
implements Store<K, V> {
    private final Store<K, V> delegate;

    public DelegatingStore(Store<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Mono<Void> save(K key, V value) {
        return this.delegate.save(key, value);
    }

    @Override
    public Mono<Void> save(Publisher<Tuple2<K, V>> entryStream) {
        return this.delegate.save(entryStream);
    }

    @Override
    public Mono<Void> delete(K id) {
        return this.delegate.delete(id);
    }

    @Override
    public Mono<Void> delete(Publisher<K> ids) {
        return this.delegate.delete(ids);
    }

    @Override
    public Mono<Void> deleteInRange(K start, K end) {
        return this.delegate.deleteInRange(start, end);
    }

    @Override
    public Mono<Void> deleteAll() {
        return this.delegate.deleteAll();
    }

    @Override
    public Mono<Void> invalidate() {
        return this.delegate.invalidate();
    }

    @Override
    public Mono<V> find(K id) {
        return this.delegate.find(id);
    }

    @Override
    public Flux<V> findInRange(K start, K end) {
        return this.delegate.findInRange(start, end);
    }

    @Override
    public Mono<Long> count() {
        return this.delegate.count();
    }

    @Override
    public Flux<K> keys() {
        return this.delegate.keys();
    }

    @Override
    public Flux<V> values() {
        return this.delegate.values();
    }

    public String toString() {
        return "DelegatingStore{delegate=" + this.delegate + '}';
    }
}

