/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.common.LogUtil;
import discord4j.common.sinks.EmissionStrategy;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.udp.UdpClient;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.concurrent.Queues;
import reactor.util.context.ContextView;

public class VoiceSocket {
    private static final Logger log = Loggers.getLogger(VoiceSocket.class);
    private static final Logger senderLog = Loggers.getLogger("discord4j.voice.protocol.udp.sender");
    private static final Logger receiverLog = Loggers.getLogger("discord4j.voice.protocol.udp.receiver");
    static final String PROTOCOL = "udp";
    static final String ENCRYPTION_MODE = "xsalsa20_poly1305";
    private static final int DISCOVERY_PACKET_LENGTH = 74;
    private static final int TYPE_LENGTH_SSRC_LENGTH = 8;
    private final UdpClient udpClient;
    private final Sinks.Many<ByteBuf> inbound;
    private final Sinks.Many<ByteBuf> outbound;
    private final EmissionStrategy emissionStrategy;

    public VoiceSocket(UdpClient udpClient) {
        this.udpClient = udpClient;
        this.inbound = VoiceSocket.newEmitterSink();
        this.outbound = VoiceSocket.newEmitterSink();
        this.emissionStrategy = EmissionStrategy.timeoutDrop(Duration.ofSeconds(5L));
    }

    private static <T> Sinks.Many<T> newEmitterSink() {
        return Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
    }

    Mono<Connection> setup(String address, int port) {
        return Mono.deferContextual(context -> ((UdpClient)((UdpClient)this.udpClient.host(address).port(port).observe(this.getObserver((ContextView)context)).doOnConnected(c -> log.debug(LogUtil.format(context, "Connected to {}"), this.address((Connection)c)))).doOnDisconnected(c -> log.debug(LogUtil.format(context, "Disconnected from {}"), this.address((Connection)c)))).handle((in, out) -> {
            Mono<Void> inboundThen = in.receive().retain().doOnNext(buf -> this.logPayload(receiverLog, (ContextView)context, (ByteBuf)buf)).doOnNext(buf -> this.emissionStrategy.emitNext(this.inbound, buf)).then();
            Mono<Void> outboundThen = out.send(this.outbound.asFlux().doOnNext(buf -> this.logPayload(senderLog, (ContextView)context, (ByteBuf)buf))).then();
            in.withConnection(c -> c.onDispose(() -> log.debug(LogUtil.format(context, "Connection disposed"))));
            return Mono.zip(inboundThen, outboundThen).then();
        }).connect());
    }

    private SocketAddress address(Connection connection) {
        Channel c = connection.channel();
        if (c instanceof DatagramChannel) {
            SocketAddress a = c.remoteAddress();
            return a != null ? a : c.localAddress();
        }
        return c.remoteAddress();
    }

    private ConnectionObserver getObserver(ContextView context) {
        return (connection, newState) -> log.debug(LogUtil.format(context, "{} {}"), newState, connection);
    }

    private void logPayload(Logger logger, ContextView context, ByteBuf buf) {
        logger.trace(LogUtil.format(context, ByteBufUtil.hexDump(buf)));
    }

    Mono<InetSocketAddress> performIpDiscovery(int ssrc) {
        Mono sendDiscoveryPacket = Mono.fromRunnable(() -> {
            ByteBuf discoveryPacket = Unpooled.buffer(74).writeShort(1).writeShort(70).writeInt(ssrc).writeZero(66);
            this.emissionStrategy.emitNext(this.outbound, discoveryPacket);
        });
        Mono<InetSocketAddress> parseResponse = this.inbound.asFlux().next().map(buf -> {
            String address = VoiceSocket.getNullTerminatedString(buf, 8);
            int port = buf.getUnsignedShortLE(72);
            buf.release();
            return InetSocketAddress.createUnresolved(address, port);
        });
        return sendDiscoveryPacket.then(parseResponse);
    }

    void send(ByteBuf data) {
        this.emissionStrategy.emitNext(this.outbound, data);
    }

    Flux<ByteBuf> getInbound() {
        return this.inbound.asFlux();
    }

    private static String getNullTerminatedString(ByteBuf buffer, int offset) {
        byte c;
        buffer.skipBytes(offset);
        ByteArrayOutputStream os = new ByteArrayOutputStream(15);
        while ((c = buffer.readByte()) != 0) {
            os.write(c);
        }
        return new String(os.toByteArray(), StandardCharsets.US_ASCII);
    }
}

