/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.audit.ActionType;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.AuditLogQueryFluxGenerator;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="AuditLogQueryFluxGenerator", generator="Immutables")
public final class AuditLogQueryFlux
extends AuditLogQueryFluxGenerator {
    @Nullable
    private final Snowflake userId;
    @Nullable
    private final ActionType actionType;
    @Nullable
    private final Snowflake before;
    @Nullable
    private final Integer limit;
    private final Guild guild;

    private AuditLogQueryFlux(Guild guild) {
        this.guild = Objects.requireNonNull(guild, "guild");
        this.userId = null;
        this.actionType = null;
        this.before = null;
        this.limit = null;
    }

    private AuditLogQueryFlux(@Nullable Snowflake userId, @Nullable ActionType actionType, @Nullable Snowflake before, @Nullable Integer limit, Guild guild) {
        this.userId = userId;
        this.actionType = actionType;
        this.before = before;
        this.limit = limit;
        this.guild = guild;
    }

    @Override
    @Nullable
    public Snowflake userId() {
        return this.userId;
    }

    @Override
    @Nullable
    public ActionType actionType() {
        return this.actionType;
    }

    @Override
    @Nullable
    public Snowflake before() {
        return this.before;
    }

    @Override
    @Nullable
    public Integer limit() {
        return this.limit;
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final AuditLogQueryFlux withUserId(@Nullable Snowflake value) {
        if (this.userId == value) {
            return this;
        }
        return new AuditLogQueryFlux(value, this.actionType, this.before, this.limit, this.guild);
    }

    public final AuditLogQueryFlux withActionType(@Nullable ActionType value) {
        if (this.actionType == value) {
            return this;
        }
        return new AuditLogQueryFlux(this.userId, value, this.before, this.limit, this.guild);
    }

    public final AuditLogQueryFlux withBefore(@Nullable Snowflake value) {
        if (this.before == value) {
            return this;
        }
        return new AuditLogQueryFlux(this.userId, this.actionType, value, this.limit, this.guild);
    }

    public final AuditLogQueryFlux withLimit(@Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new AuditLogQueryFlux(this.userId, this.actionType, this.before, value, this.guild);
    }

    public final AuditLogQueryFlux withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new AuditLogQueryFlux(this.userId, this.actionType, this.before, this.limit, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuditLogQueryFlux && this.equalTo(0, (AuditLogQueryFlux)another);
    }

    private boolean equalTo(int synthetic, AuditLogQueryFlux another) {
        return Objects.equals(this.userId, another.userId) && Objects.equals((Object)this.actionType, (Object)another.actionType) && Objects.equals(this.before, another.before) && Objects.equals(this.limit, another.limit) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.userId);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.actionType);
        h2 += (h2 << 5) + Objects.hashCode(this.before);
        h2 += (h2 << 5) + Objects.hashCode(this.limit);
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "AuditLogQueryFlux{userId=" + this.userId + ", actionType=" + (Object)((Object)this.actionType) + ", before=" + this.before + ", limit=" + this.limit + ", guild=" + this.guild + "}";
    }

    public static AuditLogQueryFlux of(Guild guild) {
        return new AuditLogQueryFlux(guild);
    }

    static AuditLogQueryFlux copyOf(AuditLogQueryFluxGenerator instance) {
        if (instance instanceof AuditLogQueryFlux) {
            return (AuditLogQueryFlux)instance;
        }
        return AuditLogQueryFlux.of(instance.guild()).withUserId(instance.userId()).withActionType(instance.actionType()).withBefore(instance.before()).withLimit(instance.limit());
    }
}

