/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.MessageEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="MessageEditSpecGenerator", generator="Immutables")
public final class MessageEditSpec
implements MessageEditSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<Message.Flag> flags_value;
    private final boolean flags_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private final List<Attachment> attachments_value;
    private final boolean attachments_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final MessageEditSpec INSTANCE = MessageEditSpec.validate(new MessageEditSpec());

    private MessageEditSpec() {
        Possible content$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible flags$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        Possible attachments$impl = Possible.absent();
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.flags_value = Possible.flatOpt(flags$impl).orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.components_value = Possible.flatOpt(components$impl).orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageEditSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible embeds$impl = builder.embeds_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible flags$impl = builder.flags_build();
        Possible components$impl = builder.components_build();
        Possible attachments$impl = builder.attachments_build();
        if (builder.filesIsSet()) {
            this.initShim.files(MessageEditSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(MessageEditSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.flags_value = Possible.flatOpt(flags$impl).orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.components_value = Possible.flatOpt(components$impl).orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageEditSpec(Possible<Optional<String>> content, Possible<Optional<List<EmbedCreateSpec>>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<Optional<AllowedMentions>> allowedMentions, Possible<Optional<List<Message.Flag>>> flags, Possible<Optional<List<LayoutComponent>>> components, Possible<Optional<List<Attachment>>> attachments) {
        Possible content$impl = content;
        Possible embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible allowedMentions$impl = allowedMentions;
        Possible flags$impl = flags;
        Possible components$impl = components;
        Possible attachments$impl = attachments;
        this.content_value = Possible.flatOpt(content$impl).orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.flags_value = Possible.flatOpt(flags$impl).orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.components_value = Possible.flatOpt(components$impl).orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.attachments_value = Possible.flatOpt(attachments$impl).orElse(null);
        this.attachments_absent = attachments$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return MessageEditSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return MessageEditSpecGenerator.super.fileSpoilers();
    }

    @Override
    public Possible<Optional<String>> content() {
        return this.content_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.content_value));
    }

    @Override
    public Possible<Optional<List<EmbedCreateSpec>>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_value));
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<Optional<AllowedMentions>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.allowedMentions_value));
    }

    @Override
    public Possible<Optional<List<Message.Flag>>> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.flags_value));
    }

    @Override
    public Possible<Optional<List<LayoutComponent>>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.components_value));
    }

    @Override
    public Possible<Optional<List<Attachment>>> attachments() {
        return this.attachments_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_value));
    }

    public MessageEditSpec withContent(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return MessageEditSpec.validate(new MessageEditSpec(newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    @Deprecated
    public MessageEditSpec withContent(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return MessageEditSpec.validate(new MessageEditSpec(newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public MessageEditSpec withContentOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return MessageEditSpec.validate(new MessageEditSpec(newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public MessageEditSpec withEmbeds(Possible<Optional<List<EmbedCreateSpec>>> possible) {
        Possible<Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    @Deprecated
    public MessageEditSpec withEmbeds(@Nullable Iterable<EmbedCreateSpec> elements) {
        Possible<Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public MessageEditSpec withEmbedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
        Possible<Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    @SafeVarargs
    public final MessageEditSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible<Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public final MessageEditSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = MessageEditSpec.createUnmodifiableList(false, MessageEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public final MessageEditSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = MessageEditSpec.createUnmodifiableList(false, MessageEditSpec.createSafeList(elements, true, false));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public final MessageEditSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = MessageEditSpec.createUnmodifiableList(false, MessageEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public final MessageEditSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = MessageEditSpec.createUnmodifiableList(false, MessageEditSpec.createSafeList(elements, true, false));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.flags(), this.components(), this.attachments()));
    }

    public MessageEditSpec withAllowedMentions(Possible<Optional<AllowedMentions>> value) {
        Possible<Optional<AllowedMentions>> newValue = Objects.requireNonNull(value);
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.flags(), this.components(), this.attachments()));
    }

    @Deprecated
    public MessageEditSpec withAllowedMentions(@Nullable AllowedMentions value) {
        Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.flags(), this.components(), this.attachments()));
    }

    public MessageEditSpec withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
        Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.flags(), this.components(), this.attachments()));
    }

    public MessageEditSpec withFlags(Possible<Optional<List<Message.Flag>>> possible) {
        Possible<Optional<List<Message.Flag>>> newValue = Objects.requireNonNull(possible);
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.components(), this.attachments()));
    }

    @Deprecated
    public MessageEditSpec withFlags(@Nullable Iterable<Message.Flag> elements) {
        Possible<Optional<List<Message.Flag>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.components(), this.attachments()));
    }

    public MessageEditSpec withFlagsOrNull(@Nullable Iterable<Message.Flag> elements) {
        Possible<Optional<List<Message.Flag>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.components(), this.attachments()));
    }

    @SafeVarargs
    public final MessageEditSpec withFlags(Message.Flag ... elements) {
        Possible<Optional<List<Message.Flag>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.components(), this.attachments()));
    }

    public MessageEditSpec withComponents(Possible<Optional<List<LayoutComponent>>> possible) {
        Possible<Optional<List<LayoutComponent>>> newValue = Objects.requireNonNull(possible);
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), newValue, this.attachments()));
    }

    @Deprecated
    public MessageEditSpec withComponents(@Nullable Iterable<LayoutComponent> elements) {
        Possible<Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), newValue, this.attachments()));
    }

    public MessageEditSpec withComponentsOrNull(@Nullable Iterable<LayoutComponent> elements) {
        Possible<Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), newValue, this.attachments()));
    }

    @SafeVarargs
    public final MessageEditSpec withComponents(LayoutComponent ... elements) {
        Possible<Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), newValue, this.attachments()));
    }

    public MessageEditSpec withAttachments(Possible<Optional<List<Attachment>>> possible) {
        Possible<Optional<List<Attachment>>> newValue = Objects.requireNonNull(possible);
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), newValue));
    }

    @Deprecated
    public MessageEditSpec withAttachments(@Nullable Iterable<Attachment> elements) {
        Possible<Optional<List<Attachment>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), newValue));
    }

    public MessageEditSpec withAttachmentsOrNull(@Nullable Iterable<Attachment> elements) {
        Possible<Optional<List<Attachment>>> newValue = Possible.of(Optional.ofNullable(elements).map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), newValue));
    }

    @SafeVarargs
    public final MessageEditSpec withAttachments(Attachment ... elements) {
        Possible<Optional<List<Attachment>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
        return MessageEditSpec.validate(new MessageEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.flags(), this.components(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageEditSpec && this.equalTo(0, (MessageEditSpec)another);
    }

    private boolean equalTo(int synthetic, MessageEditSpec another) {
        return this.content().equals(another.content()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.flags_value, another.flags_value) && Objects.equals(this.components_value, another.components_value) && Objects.equals(this.attachments_value, another.attachments_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.content().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.embeds_value);
        h2 += (h2 << 5) + this.files.hashCode();
        h2 += (h2 << 5) + this.fileSpoilers.hashCode();
        h2 += (h2 << 5) + this.allowedMentions().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.flags_value);
        h2 += (h2 << 5) + Objects.hashCode(this.components_value);
        h2 += (h2 << 5) + Objects.hashCode(this.attachments_value);
        return h2;
    }

    public String toString() {
        return "MessageEditSpec{content=" + this.content().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", flags=" + Objects.toString(this.flags_value) + ", components=" + Objects.toString(this.components_value) + ", attachments=" + Objects.toString(this.attachments_value) + "}";
    }

    public static MessageEditSpec create() {
        return INSTANCE;
    }

    private static MessageEditSpec validate(MessageEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static MessageEditSpec copyOf(MessageEditSpecGenerator instance) {
        if (instance instanceof MessageEditSpec) {
            return (MessageEditSpec)instance;
        }
        return MessageEditSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public List<Message.Flag> flagsOrElse(List<Message.Flag> defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isAttachmentsPresent() {
        return !this.attachments_absent;
    }

    public List<Attachment> attachmentsOrElse(List<Attachment> defaultValue) {
        return !this.attachments_absent ? this.attachments_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MessageEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_FILES = 1L;
        private static final long OPT_BIT_FILE_SPOILERS = 2L;
        private long optBits;
        private Possible<Optional<String>> content_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private boolean embeds_explicitNull;
        private Possible<Optional<AllowedMentions>> allowedMentions_possible = Possible.absent();
        private List<Message.Flag> flags_list = null;
        private boolean flags_explicitNull;
        private List<LayoutComponent> components_list = null;
        private boolean components_explicitNull;
        private List<Attachment> attachments_list = null;
        private boolean attachments_explicitNull;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();

        private Builder() {
        }

        public final Builder from(MessageEditSpec instance) {
            return this.from((MessageEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(MessageEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.embeds(instance.embeds());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.allowedMentions(instance.allowedMentions());
            this.flags(instance.flags());
            this.components(instance.components());
            this.attachments(instance.attachments());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<Optional<String>> value) {
            this.content_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder content(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder contentOrNull(@Nullable String value) {
            this.content_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            this.embeds_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Possible<Optional<List<EmbedCreateSpec>>> elements) {
            this.embeds_list = null;
            this.embeds_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.embeds_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.embeds_explicitNull = true;
                }
            });
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            this.embeds_explicitNull = false;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder embeds(@Nullable Iterable<EmbedCreateSpec> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embedsOrNull(@Nullable Iterable<EmbedCreateSpec> elements) {
            if (elements == null) {
                this.embeds_list = null;
                this.embeds_explicitNull = true;
            } else {
                this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.embeds_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<Optional<AllowedMentions>> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder allowedMentions(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentionsOrNull(@Nullable AllowedMentions value) {
            this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFlag(Message.Flag element) {
            this.flags_getOrCreate().add(element);
            this.flags_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFlags(List<Message.Flag> elements) {
            this.flags_getOrCreate().addAll(elements);
            this.flags_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder flags(Possible<Optional<List<Message.Flag>>> elements) {
            this.flags_list = null;
            this.flags_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.flags_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.flags_explicitNull = true;
                }
            });
            return this;
        }

        @CanIgnoreReturnValue
        public Builder flags(List<Message.Flag> elements) {
            this.flags_list = new ArrayList<Message.Flag>(elements);
            this.flags_explicitNull = false;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder flags(@Nullable Iterable<Message.Flag> elements) {
            if (elements == null) {
                this.flags_list = null;
                this.flags_explicitNull = true;
            } else {
                this.flags_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.flags_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder flagsOrNull(@Nullable Iterable<Message.Flag> elements) {
            if (elements == null) {
                this.flags_list = null;
                this.flags_explicitNull = true;
            } else {
                this.flags_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.flags_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            this.components_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(List<LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            this.components_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<Optional<List<LayoutComponent>>> elements) {
            this.components_list = null;
            this.components_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.components_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.components_explicitNull = true;
                }
            });
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(List<LayoutComponent> elements) {
            this.components_list = new ArrayList<LayoutComponent>(elements);
            this.components_explicitNull = false;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder components(@Nullable Iterable<LayoutComponent> elements) {
            if (elements == null) {
                this.components_list = null;
                this.components_explicitNull = true;
            } else {
                this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.components_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder componentsOrNull(@Nullable Iterable<LayoutComponent> elements) {
            if (elements == null) {
                this.components_list = null;
                this.components_explicitNull = true;
            } else {
                this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.components_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAttachment(Attachment element) {
            this.attachments_getOrCreate().add(element);
            this.attachments_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllAttachments(List<Attachment> elements) {
            this.attachments_getOrCreate().addAll(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder attachments(Possible<Optional<List<Attachment>>> elements) {
            this.attachments_list = null;
            this.attachments_explicitNull = false;
            elements.toOptional().ifPresent(e -> {
                if (e.isPresent()) {
                    this.attachments_getOrCreate().addAll((Collection)e.get());
                } else {
                    this.attachments_explicitNull = true;
                }
            });
            return this;
        }

        @CanIgnoreReturnValue
        public Builder attachments(List<Attachment> elements) {
            this.attachments_list = new ArrayList<Attachment>(elements);
            this.attachments_explicitNull = false;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder attachments(@Nullable Iterable<Attachment> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder attachmentsOrNull(@Nullable Iterable<Attachment> elements) {
            if (elements == null) {
                this.attachments_list = null;
                this.attachments_explicitNull = true;
            } else {
                this.attachments_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
                this.attachments_explicitNull = false;
            }
            return this;
        }

        public MessageEditSpec build() {
            return MessageEditSpec.validate(new MessageEditSpec(this));
        }

        private boolean filesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private Possible<Optional<String>> content_build() {
            return this.content_possible;
        }

        private Possible<Optional<List<EmbedCreateSpec>>> embeds_build() {
            return this.embeds_list == null && !this.embeds_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.embeds_list));
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private Possible<Optional<AllowedMentions>> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<Optional<List<Message.Flag>>> flags_build() {
            return this.flags_list == null && !this.flags_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.flags_list));
        }

        private List<Message.Flag> flags_getOrCreate() {
            if (this.flags_list == null) {
                this.flags_list = new ArrayList<Message.Flag>();
            }
            return this.flags_list;
        }

        private Possible<Optional<List<LayoutComponent>>> components_build() {
            return this.components_list == null && !this.components_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.components_list));
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }

        private Possible<Optional<List<Attachment>>> attachments_build() {
            return this.attachments_list == null && !this.attachments_explicitNull ? Possible.absent() : Possible.of(Optional.ofNullable(this.attachments_list));
        }

        private List<Attachment> attachments_getOrCreate() {
            if (this.attachments_list == null) {
                this.attachments_list = new ArrayList<Attachment>();
            }
            return this.attachments_list;
        }
    }

    @Generated(from="MessageEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = MessageEditSpec.createUnmodifiableList(false, MessageEditSpec.createSafeList(MessageEditSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = MessageEditSpec.createUnmodifiableList(false, MessageEditSpec.createSafeList(MessageEditSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build MessageEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

