/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.WelcomeScreenChannelData;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="WelcomeScreenChannelData", generator="Immutables")
public final class ImmutableWelcomeScreenChannelData
implements WelcomeScreenChannelData {
    private final String channelId;
    private final String description;
    private final String emojiId;
    private final String emojiName;

    private ImmutableWelcomeScreenChannelData(String channelId, String description, Optional<String> emojiId, Optional<String> emojiName) {
        this.channelId = Objects.requireNonNull(channelId, "channelId");
        this.description = Objects.requireNonNull(description, "description");
        this.emojiId = emojiId.orElse(null);
        this.emojiName = emojiName.orElse(null);
    }

    private ImmutableWelcomeScreenChannelData(ImmutableWelcomeScreenChannelData original, String channelId, String description, String emojiId, String emojiName) {
        this.channelId = channelId;
        this.description = description;
        this.emojiId = emojiId;
        this.emojiName = emojiName;
    }

    @Override
    @JsonProperty(value="channel_id")
    public String channelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="emoji_id")
    public Optional<String> emojiId() {
        return Optional.ofNullable(this.emojiId);
    }

    @Override
    @JsonProperty(value="emoji_name")
    public Optional<String> emojiName() {
        return Optional.ofNullable(this.emojiName);
    }

    public final ImmutableWelcomeScreenChannelData withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ImmutableWelcomeScreenChannelData(this, newValue, this.description, this.emojiId, this.emojiName);
    }

    public final ImmutableWelcomeScreenChannelData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableWelcomeScreenChannelData(this, this.channelId, newValue, this.emojiId, this.emojiName);
    }

    public final ImmutableWelcomeScreenChannelData withEmojiId(String value) {
        String newValue = Objects.requireNonNull(value, "emojiId");
        if (Objects.equals(this.emojiId, newValue)) {
            return this;
        }
        return new ImmutableWelcomeScreenChannelData(this, this.channelId, this.description, newValue, this.emojiName);
    }

    public final ImmutableWelcomeScreenChannelData withEmojiId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emojiId, value)) {
            return this;
        }
        return new ImmutableWelcomeScreenChannelData(this, this.channelId, this.description, value, this.emojiName);
    }

    public final ImmutableWelcomeScreenChannelData withEmojiName(String value) {
        String newValue = Objects.requireNonNull(value, "emojiName");
        if (Objects.equals(this.emojiName, newValue)) {
            return this;
        }
        return new ImmutableWelcomeScreenChannelData(this, this.channelId, this.description, this.emojiId, newValue);
    }

    public final ImmutableWelcomeScreenChannelData withEmojiName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emojiName, value)) {
            return this;
        }
        return new ImmutableWelcomeScreenChannelData(this, this.channelId, this.description, this.emojiId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWelcomeScreenChannelData && this.equalTo(0, (ImmutableWelcomeScreenChannelData)another);
    }

    private boolean equalTo(int synthetic, ImmutableWelcomeScreenChannelData another) {
        return this.channelId.equals(another.channelId) && this.description.equals(another.description) && Objects.equals(this.emojiId, another.emojiId) && Objects.equals(this.emojiName, another.emojiName);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.channelId.hashCode();
        h2 += (h2 << 5) + this.description.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.emojiId);
        h2 += (h2 << 5) + Objects.hashCode(this.emojiName);
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WelcomeScreenChannelData{");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("description=").append(this.description);
        if (this.emojiId != null) {
            builder.append(", ");
            builder.append("emojiId=").append(this.emojiId);
        }
        if (this.emojiName != null) {
            builder.append(", ");
            builder.append("emojiName=").append(this.emojiName);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWelcomeScreenChannelData fromJson(Json json) {
        Builder builder = ImmutableWelcomeScreenChannelData.builder();
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.emojiId != null) {
            builder.emojiId(json.emojiId);
        }
        if (json.emojiName != null) {
            builder.emojiName(json.emojiName);
        }
        return builder.build();
    }

    public static ImmutableWelcomeScreenChannelData of(String channelId, String description, Optional<String> emojiId, Optional<String> emojiName) {
        return new ImmutableWelcomeScreenChannelData(channelId, description, emojiId, emojiName);
    }

    public static ImmutableWelcomeScreenChannelData copyOf(WelcomeScreenChannelData instance) {
        if (instance instanceof ImmutableWelcomeScreenChannelData) {
            return (ImmutableWelcomeScreenChannelData)instance;
        }
        return ImmutableWelcomeScreenChannelData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WelcomeScreenChannelData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private long initBits = 3L;
        private String channelId;
        private String description;
        private String emojiId;
        private String emojiName;

        private Builder() {
        }

        public final Builder from(WelcomeScreenChannelData instance) {
            Optional<String> emojiNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.channelId(instance.channelId());
            this.description(instance.description());
            Optional<String> emojiIdOptional = instance.emojiId();
            if (emojiIdOptional.isPresent()) {
                this.emojiId(emojiIdOptional);
            }
            if ((emojiNameOptional = instance.emojiName()).isPresent()) {
                this.emojiName(emojiNameOptional);
            }
            return this;
        }

        @JsonProperty(value="channel_id")
        public final Builder channelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder emojiId(String emojiId) {
            this.emojiId = Objects.requireNonNull(emojiId, "emojiId");
            return this;
        }

        @JsonProperty(value="emoji_id")
        public final Builder emojiId(Optional<String> emojiId) {
            this.emojiId = emojiId.orElse(null);
            return this;
        }

        public final Builder emojiName(String emojiName) {
            this.emojiName = Objects.requireNonNull(emojiName, "emojiName");
            return this;
        }

        @JsonProperty(value="emoji_name")
        public final Builder emojiName(Optional<String> emojiName) {
            this.emojiName = emojiName.orElse(null);
            return this;
        }

        public ImmutableWelcomeScreenChannelData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWelcomeScreenChannelData(null, this.channelId, this.description, this.emojiId, this.emojiName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build WelcomeScreenChannelData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WelcomeScreenChannelData", generator="Immutables")
    static final class Json
    implements WelcomeScreenChannelData {
        String channelId;
        String description;
        Optional<String> emojiId = Optional.empty();
        Optional<String> emojiName = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="emoji_id")
        public void setEmojiId(Optional<String> emojiId) {
            this.emojiId = emojiId;
        }

        @JsonProperty(value="emoji_name")
        public void setEmojiName(Optional<String> emojiName) {
            this.emojiName = emojiName;
        }

        @Override
        public String channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> emojiId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> emojiName() {
            throw new UnsupportedOperationException();
        }
    }
}

