/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.rest.entity.RestChannel;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

class BaseChannel
implements Channel {
    private final ChannelData data;
    private final GatewayDiscordClient gateway;
    private final RestChannel rest;

    BaseChannel(GatewayDiscordClient gateway, ChannelData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.rest = RestChannel.create(gateway.getRestClient(), Snowflake.of(data.id()));
    }

    @Override
    public final GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public final Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    @Override
    public RestChannel getRestChannel() {
        return this.rest;
    }

    @Override
    public final Channel.Type getType() {
        return Channel.Type.of(this.data.type());
    }

    @Override
    public final Mono<Void> delete(@Nullable String reason) {
        return this.rest.delete(reason);
    }

    ChannelData getData() {
        return this.data;
    }

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !BaseChannel.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        BaseChannel that = (BaseChannel)obj;
        return this.getId().equals(that.getId());
    }

    public final int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "BaseChannel{data=" + this.data + '}';
    }
}

