/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.AuditSpec;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModRuleCreateRequest;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import discord4j.discordjson.possible.Possible;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
interface AutoModRuleCreateSpecGenerator
extends AuditSpec<AutoModRuleCreateRequest> {
    public String name();

    public int eventType();

    public int triggerType();

    public Possible<AutoModTriggerMetaData> triggerMetaData();

    @Value.Default
    default public List<AutoModActionData> actions() {
        return Collections.emptyList();
    }

    public Possible<Boolean> enabled();

    public Possible<List<Snowflake>> exemptRoles();

    public Possible<List<Snowflake>> exemptChannels();

    @Override
    default public AutoModRuleCreateRequest asRequest() {
        return AutoModRuleCreateRequest.builder().name(this.name()).eventType(this.eventType()).triggerType(this.triggerType()).triggerMetadata(this.triggerMetaData()).actions(this.actions()).enabled(this.enabled()).exemptRoles(InternalSpecUtils.mapPossible(this.exemptRoles(), r -> r.stream().map(Snowflake::asLong).map(Id::of).collect(Collectors.toList()))).exemptChannels(InternalSpecUtils.mapPossible(this.exemptChannels(), r -> r.stream().map(Snowflake::asLong).map(Id::of).collect(Collectors.toList()))).build();
    }
}

