/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common;

import java.time.Duration;
import java.util.concurrent.locks.LockSupport;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.util.concurrent.Queues;

public class ResettableInterval
implements Sinks.EmitFailureHandler {
    private final Scheduler scheduler;
    private final Disposable.Swap task;
    private final Sinks.Many<Long> sink = Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);

    public ResettableInterval(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.task = Disposables.swap();
    }

    public void start(Duration delay, Duration period) {
        this.task.update(Flux.interval(delay, period, this.scheduler).subscribe(tick -> this.sink.emitNext((Long)tick, this)));
    }

    public void stop() {
        if (this.task.get() != null) {
            ((Disposable)this.task.get()).dispose();
        }
    }

    public Flux<Long> ticks() {
        return this.sink.asFlux();
    }

    @Override
    public boolean onEmitFailure(SignalType signalType, Sinks.EmitResult result) {
        if (this.task.get() == null) {
            return false;
        }
        switch (result) {
            case FAIL_NON_SERIALIZED: {
                return true;
            }
            case FAIL_OVERFLOW: {
                LockSupport.parkNanos(10L);
                return true;
            }
        }
        return false;
    }
}

