/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.flac;

import com.sedmelluq.discord.lavaplayer.container.flac.FlacSeekPoint;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import com.sedmelluq.discord.lavaplayer.container.flac.frame.FlacFrameReader;
import com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import com.sedmelluq.discord.lavaplayer.tools.io.BitStreamReader;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;

public class FlacTrackProvider {
    private final FlacTrackInfo info;
    private final SeekableInputStream inputStream;
    private final AudioPipeline downstream;
    private final BitStreamReader bitStreamReader;
    private final int[] decodingBuffer;
    private final int[][] rawSampleBuffers;
    private final short[][] sampleBuffers;

    public FlacTrackProvider(AudioProcessingContext context, FlacTrackInfo info, SeekableInputStream inputStream) {
        this.info = info;
        this.inputStream = inputStream;
        this.downstream = AudioPipelineFactory.create(context, new PcmFormat(info.stream.channelCount, info.stream.sampleRate));
        this.bitStreamReader = new BitStreamReader(inputStream);
        this.decodingBuffer = new int[32];
        this.rawSampleBuffers = new int[info.stream.channelCount][];
        this.sampleBuffers = new short[info.stream.channelCount][];
        for (int i = 0; i < this.rawSampleBuffers.length; ++i) {
            this.rawSampleBuffers[i] = new int[info.stream.maximumBlockSize];
            this.sampleBuffers[i] = new short[info.stream.maximumBlockSize];
        }
    }

    public void provideFrames() throws InterruptedException {
        try {
            int sampleCount;
            while ((sampleCount = this.readFlacFrame()) != 0) {
                this.downstream.process(this.sampleBuffers, 0, sampleCount);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int readFlacFrame() throws IOException {
        return FlacFrameReader.readFlacFrame(this.inputStream, this.bitStreamReader, this.info.stream, this.rawSampleBuffers, this.sampleBuffers, this.decodingBuffer);
    }

    public void seekToTimecode(long timecode) {
        try {
            FlacSeekPoint seekPoint = this.findSeekPointForTime(timecode);
            this.inputStream.seek(this.info.firstFramePosition + seekPoint.byteOffset);
            this.downstream.seekPerformed(timecode, seekPoint.sampleIndex * 1000L / (long)this.info.stream.sampleRate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private FlacSeekPoint findSeekPointForTime(long timecode) {
        if (this.info.seekPointCount == 0) {
            return new FlacSeekPoint(0L, 0L, 0);
        }
        long targetSampleIndex = timecode * (long)this.info.stream.sampleRate / 1000L;
        return this.binarySearchSeekPoints(this.info.seekPoints, this.info.seekPointCount, targetSampleIndex);
    }

    private FlacSeekPoint binarySearchSeekPoints(FlacSeekPoint[] seekPoints, int length, long targetSampleIndex) {
        int low = 0;
        int high = length - 1;
        while (high > low) {
            int mid = (low + high + 1) / 2;
            if (this.info.seekPoints[mid].sampleIndex > targetSampleIndex) {
                high = mid - 1;
                continue;
            }
            low = mid;
        }
        return seekPoints[low];
    }

    public void close() {
        this.downstream.close();
    }
}

