/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.PartialStickerData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="StickerData", generator="Immutables")
public final class ImmutableStickerData
implements StickerData {
    private final long id_value;
    private final String name;
    private final int formatType;
    private final long packId_value;
    private final boolean packId_absent;
    private final String description;
    private final String tags_value;
    private final boolean tags_absent;
    private final String asset_value;
    private final boolean asset_absent;
    private final Boolean available_value;
    private final boolean available_absent;
    private final int type;
    private final long guildId_value;
    private final boolean guildId_absent;
    private final Integer sortValue_value;
    private final boolean sortValue_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStickerData(Id id, String name, int formatType, Possible<Id> packId, Optional<String> description, Possible<String> tags, Possible<String> asset, Possible<Boolean> available, int type, Possible<Id> guildId, Possible<Integer> sortValue) {
        Id id$impl = id;
        this.name = Objects.requireNonNull(name, "name");
        this.formatType = formatType;
        Possible<Id> packId$impl = packId;
        this.description = description.orElse(null);
        Possible<String> tags$impl = tags;
        Possible<String> asset$impl = asset;
        Possible<Boolean> available$impl = available;
        this.type = type;
        Possible<Id> guildId$impl = guildId;
        Possible<Integer> sortValue$impl = sortValue;
        this.id_value = id$impl.asLong();
        this.packId_value = packId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.packId_absent = packId$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.asset_value = asset$impl.toOptional().orElse(null);
        this.asset_absent = asset$impl.isAbsent();
        this.available_value = available$impl.toOptional().orElse(null);
        this.available_absent = available$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.sortValue_value = sortValue$impl.toOptional().orElse(null);
        this.sortValue_absent = sortValue$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableStickerData(ImmutableStickerData original, Id id, String name, int formatType, Possible<Id> packId, String description, Possible<String> tags, Possible<String> asset, Possible<Boolean> available, int type, Possible<Id> guildId, Possible<Integer> sortValue) {
        Id id$impl = id;
        this.name = name;
        this.formatType = formatType;
        Possible<Id> packId$impl = packId;
        this.description = description;
        Possible<String> tags$impl = tags;
        Possible<String> asset$impl = asset;
        Possible<Boolean> available$impl = available;
        this.type = type;
        Possible<Id> guildId$impl = guildId;
        Possible<Integer> sortValue$impl = sortValue;
        this.id_value = id$impl.asLong();
        this.packId_value = packId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.packId_absent = packId$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.asset_value = asset$impl.toOptional().orElse(null);
        this.asset_absent = asset$impl.isAbsent();
        this.available_value = available$impl.toOptional().orElse(null);
        this.available_absent = available$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.sortValue_value = sortValue$impl.toOptional().orElse(null);
        this.sortValue_absent = sortValue$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of(this.id_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="format_type")
    public int formatType() {
        return this.formatType;
    }

    @Override
    @JsonProperty(value="pack_id")
    public Possible<Id> packId() {
        return this.packId_absent ? Possible.absent() : Possible.of(Id.of(this.packId_value));
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="tags")
    public Possible<String> tags() {
        return this.tags_absent ? Possible.absent() : Possible.of(this.tags_value);
    }

    @Override
    @JsonProperty(value="asset")
    @Deprecated
    public Possible<String> asset() {
        return this.asset_absent ? Possible.absent() : Possible.of(this.asset_value);
    }

    @Override
    @JsonProperty(value="available")
    public Possible<Boolean> available() {
        return this.available_absent ? Possible.absent() : Possible.of(this.available_value);
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of(Id.of(this.guildId_value));
    }

    @Override
    @JsonProperty(value="sort_value")
    public Possible<Integer> sortValue() {
        return this.sortValue_absent ? Possible.absent() : Possible.of(this.sortValue_value);
    }

    public ImmutableStickerData withId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableStickerData(this, newValue, this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableStickerData(this, newValue, this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public final ImmutableStickerData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), newValue, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public final ImmutableStickerData withFormatType(int value) {
        if (this.formatType == value) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.name, value, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withPackId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, newValue, this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withPackId(long value) {
        Possible<Id> newValue = Possible.of(Id.of(value));
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, newValue, this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public final ImmutableStickerData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), newValue, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public final ImmutableStickerData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), value, this.tags(), this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withTags(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, newValue, this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withTags(String value) {
        Possible<String> newValue = Possible.of(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, newValue, this.asset(), this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withAsset(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), newValue, this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withAsset(String value) {
        Possible<String> newValue = Possible.of(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), newValue, this.available(), this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withAvailable(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), newValue, this.type, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withAvailable(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), newValue, this.type, this.guildId(), this.sortValue());
    }

    public final ImmutableStickerData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), value, this.guildId(), this.sortValue());
    }

    public ImmutableStickerData withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, newValue, this.sortValue());
    }

    public ImmutableStickerData withGuildId(long value) {
        Possible<Id> newValue = Possible.of(Id.of(value));
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, newValue, this.sortValue());
    }

    public ImmutableStickerData withSortValue(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), newValue);
    }

    public ImmutableStickerData withSortValue(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new ImmutableStickerData(this, this.id(), this.name, this.formatType, this.packId(), this.description, this.tags(), this.asset(), this.available(), this.type, this.guildId(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerData && this.equalTo(0, (ImmutableStickerData)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerData another) {
        return Objects.equals(this.id_value, another.id_value) && this.name.equals(another.name) && this.formatType == another.formatType && this.packId().equals(another.packId()) && Objects.equals(this.description, another.description) && this.tags().equals(another.tags()) && this.asset().equals(another.asset()) && this.available().equals(another.available()) && this.type == another.type && this.guildId().equals(another.guildId()) && this.sortValue().equals(another.sortValue());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id_value);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.formatType;
        h2 += (h2 << 5) + this.packId().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        h2 += (h2 << 5) + this.tags().hashCode();
        h2 += (h2 << 5) + this.asset().hashCode();
        h2 += (h2 << 5) + this.available().hashCode();
        h2 += (h2 << 5) + this.type;
        h2 += (h2 << 5) + this.guildId().hashCode();
        h2 += (h2 << 5) + this.sortValue().hashCode();
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StickerData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("formatType=").append(this.formatType);
        builder.append(", ");
        builder.append("packId=").append(this.packId().toString());
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("tags=").append(this.tags().toString());
        builder.append(", ");
        builder.append("asset=").append(this.asset().toString());
        builder.append(", ");
        builder.append("available=").append(this.available().toString());
        builder.append(", ");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("guildId=").append(this.guildId().toString());
        builder.append(", ");
        builder.append("sortValue=").append(this.sortValue().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStickerData fromJson(Json json) {
        Builder builder = ImmutableStickerData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.formatTypeIsSet) {
            builder.formatType(json.formatType);
        }
        if (json.packId != null) {
            builder.packId(json.packId);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.tags != null) {
            builder.tags(json.tags);
        }
        if (json.asset != null) {
            builder.asset(json.asset);
        }
        if (json.available != null) {
            builder.available(json.available);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.sortValue != null) {
            builder.sortValue(json.sortValue);
        }
        return builder.build();
    }

    public static ImmutableStickerData of(Id id, String name, int formatType, Possible<Id> packId, Optional<String> description, Possible<String> tags, Possible<String> asset, Possible<Boolean> available, int type, Possible<Id> guildId, Possible<Integer> sortValue) {
        return new ImmutableStickerData(id, name, formatType, packId, description, tags, asset, available, type, guildId, sortValue);
    }

    public static ImmutableStickerData copyOf(StickerData instance) {
        if (instance instanceof ImmutableStickerData) {
            return (ImmutableStickerData)instance;
        }
        return ImmutableStickerData.builder().from(instance).build();
    }

    public boolean isPackIdPresent() {
        return !this.packId_absent;
    }

    public long packIdOrElse(long defaultValue) {
        return !this.packId_absent ? this.packId_value : defaultValue;
    }

    public boolean isTagsPresent() {
        return !this.tags_absent;
    }

    public String tagsOrElse(String defaultValue) {
        return !this.tags_absent ? this.tags_value : defaultValue;
    }

    public boolean isAssetPresent() {
        return !this.asset_absent;
    }

    public String assetOrElse(String defaultValue) {
        return !this.asset_absent ? this.asset_value : defaultValue;
    }

    public boolean isAvailablePresent() {
        return !this.available_absent;
    }

    public Boolean availableOrElse(Boolean defaultValue) {
        return !this.available_absent ? this.available_value : defaultValue;
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isSortValuePresent() {
        return !this.sortValue_absent;
    }

    public Integer sortValueOrElse(Integer defaultValue) {
        return !this.sortValue_absent ? this.sortValue_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StickerData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_FORMAT_TYPE = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private Id id_id = null;
        private Possible<Id> packId_possible = Possible.absent();
        private Possible<String> tags_possible = Possible.absent();
        private Possible<String> asset_possible = Possible.absent();
        private Possible<Boolean> available_possible = Possible.absent();
        private Possible<Id> guildId_possible = Possible.absent();
        private Possible<Integer> sortValue_possible = Possible.absent();
        private String name;
        private int formatType;
        private String description;
        private int type;

        private Builder() {
        }

        public final Builder from(PartialStickerData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StickerData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PartialStickerData instance;
            long bits = 0L;
            if (object instanceof PartialStickerData) {
                instance = (PartialStickerData)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.formatType(instance.formatType());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof StickerData) {
                instance = (StickerData)object;
                this.packId(instance.packId());
                this.sortValue(instance.sortValue());
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
                this.available(instance.available());
                Optional<String> descriptionOptional = instance.description();
                if (descriptionOptional.isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.formatType(instance.formatType());
                    bits |= 4L;
                }
                this.asset(instance.asset());
                this.type(instance.type());
                this.guildId(instance.guildId());
                this.tags(instance.tags());
            }
        }

        public Builder id(String value) {
            this.id_id = Id.of(value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="format_type")
        public final Builder formatType(int formatType) {
            this.formatType = formatType;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder packId(String value) {
            this.packId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder packId(long value) {
            this.packId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder packId(Id value) {
            this.packId_possible = Possible.of(value);
            return this;
        }

        @JsonProperty(value="pack_id")
        public Builder packId(Possible<Id> value) {
            this.packId_possible = value;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="tags")
        public Builder tags(Possible<String> value) {
            this.tags_possible = value;
            return this;
        }

        public Builder tags(String value) {
            this.tags_possible = Possible.of(value);
            return this;
        }

        @JsonProperty(value="asset")
        public Builder asset(Possible<String> value) {
            this.asset_possible = value;
            return this;
        }

        public Builder asset(String value) {
            this.asset_possible = Possible.of(value);
            return this;
        }

        @JsonProperty(value="available")
        public Builder available(Possible<Boolean> value) {
            this.available_possible = value;
            return this;
        }

        public Builder available(Boolean value) {
            this.available_possible = Possible.of(value);
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of(value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        @JsonProperty(value="sort_value")
        public Builder sortValue(Possible<Integer> value) {
            this.sortValue_possible = value;
            return this;
        }

        public Builder sortValue(Integer value) {
            this.sortValue_possible = Possible.of(value);
            return this;
        }

        public ImmutableStickerData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerData(null, this.id_build(), this.name, this.formatType, this.packId_build(), this.description, this.tags_build(), this.asset_build(), this.available_build(), this.type, this.guildId_build(), this.sortValue_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("formatType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build StickerData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Possible<Id> packId_build() {
            return this.packId_possible;
        }

        private Possible<String> tags_build() {
            return this.tags_possible;
        }

        private Possible<String> asset_build() {
            return this.asset_possible;
        }

        private Possible<Boolean> available_build() {
            return this.available_possible;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<Integer> sortValue_build() {
            return this.sortValue_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StickerData", generator="Immutables")
    static final class Json
    implements StickerData {
        Id id;
        String name;
        int formatType;
        boolean formatTypeIsSet;
        Possible<Id> packId = Possible.absent();
        Optional<String> description = Optional.empty();
        Possible<String> tags = Possible.absent();
        Possible<String> asset = Possible.absent();
        Possible<Boolean> available = Possible.absent();
        int type;
        boolean typeIsSet;
        Possible<Id> guildId = Possible.absent();
        Possible<Integer> sortValue = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="format_type")
        public void setFormatType(int formatType) {
            this.formatType = formatType;
            this.formatTypeIsSet = true;
        }

        @JsonProperty(value="pack_id")
        public void setPackId(Possible<Id> packId) {
            this.packId = packId;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="tags")
        public void setTags(Possible<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="asset")
        public void setAsset(Possible<String> asset) {
            this.asset = asset;
        }

        @JsonProperty(value="available")
        public void setAvailable(Possible<Boolean> available) {
            this.available = available;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="sort_value")
        public void setSortValue(Possible<Integer> sortValue) {
            this.sortValue = sortValue;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int formatType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> packId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> asset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> available() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> sortValue() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="StickerData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StickerData, attribute initializers form cycle " + attributes;
        }
    }
}

